/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.reward;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.hooks.PermissionsHook;
import dev.aurelium.auraskills.common.reward.SkillReward;
import dev.aurelium.auraskills.common.reward.type.PermissionReward;
import dev.aurelium.auraskills.common.reward.type.StatReward;
import dev.aurelium.auraskills.common.user.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class RewardTable {
    private final AuraSkillsPlugin plugin;
    private final List<Stat> statsLeveled;
    private final Map<Integer, List<SkillReward>> rewards;

    public RewardTable(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
        this.rewards = new ConcurrentHashMap<Integer, List<SkillReward>>();
        this.statsLeveled = new ArrayList<Stat>();
    }

    public ImmutableList<SkillReward> getRewards(int level) {
        return ImmutableList.copyOf((Collection)this.rewards.getOrDefault(level, new ArrayList()));
    }

    public Map<Integer, List<SkillReward>> getRewardsMap() {
        return this.rewards;
    }

    public void addReward(@NotNull SkillReward reward, int level) {
        StatReward statReward;
        List rewards = this.rewards.computeIfAbsent(level, k -> new ArrayList());
        rewards.add(reward);
        if (reward instanceof StatReward && !this.statsLeveled.contains((statReward = (StatReward)reward).getStat())) {
            this.statsLeveled.add(statReward.getStat());
        }
    }

    public ImmutableList<Stat> getStatsLeveled() {
        return ImmutableList.copyOf(this.statsLeveled);
    }

    public <T extends SkillReward> Map<Integer, ImmutableList<T>> searchRewards(Class<T> type) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<Integer, List<SkillReward>> entry : this.rewards.entrySet()) {
            ArrayList<SkillReward> rewardList = new ArrayList<SkillReward>();
            for (SkillReward reward : entry.getValue()) {
                if (!type.isInstance(reward)) continue;
                rewardList.add((SkillReward)type.cast(reward));
            }
            if (rewardList.isEmpty()) continue;
            builder.put((Object)entry.getKey(), (Object)ImmutableList.copyOf(rewardList));
        }
        return builder.build();
    }

    public <T extends SkillReward> ImmutableList<T> searchRewards(Class<T> type, int level) {
        ImmutableList<SkillReward> levelRewards = this.getRewards(level);
        ArrayList<SkillReward> rewardList = new ArrayList<SkillReward>();
        for (SkillReward reward : levelRewards) {
            if (!type.isInstance(reward)) continue;
            rewardList.add((SkillReward)type.cast(reward));
        }
        return ImmutableList.copyOf(rewardList);
    }

    public Map<Stat, Double> getStatLevels(int level) {
        ConcurrentHashMap<Stat, Double> statsMap = new ConcurrentHashMap<Stat, Double>();
        Map<Integer, ImmutableList<StatReward>> statRewardMap = this.searchRewards(StatReward.class);
        for (int i = this.plugin.config().getStartLevel() + 1; i <= level; ++i) {
            ImmutableList<StatReward> statRewardList = statRewardMap.get(i);
            if (statRewardList == null) continue;
            for (StatReward statReward : statRewardList) {
                double existing = statsMap.getOrDefault(statReward.getStat(), 0.0);
                statsMap.put(statReward.getStat(), existing + statReward.getValue());
            }
        }
        return statsMap;
    }

    public void applyPermissions(User player, int level) {
        Map<Integer, ImmutableList<PermissionReward>> permissionRewardMap = this.searchRewards(PermissionReward.class);
        for (Map.Entry<Integer, ImmutableList<PermissionReward>> entry : permissionRewardMap.entrySet()) {
            int entryLevel = entry.getKey();
            for (PermissionReward reward : entry.getValue()) {
                if (!this.plugin.getHookManager().isRegistered(PermissionsHook.class)) continue;
                PermissionsHook hook = this.plugin.getHookManager().getHook(PermissionsHook.class);
                if (level >= entryLevel) {
                    hook.setPermission(player, reward.getPermission(), reward.getValue());
                    continue;
                }
                hook.unsetPermission(player, reward.getPermission(), reward.getValue());
            }
        }
    }
}

