/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.reward;

import dev.aurelium.auraskills.api.registry.NamespacedRegistry;
import dev.aurelium.auraskills.api.skill.CustomSkill;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.reward.RewardTable;
import dev.aurelium.auraskills.common.reward.RewardType;
import dev.aurelium.auraskills.common.reward.SkillReward;
import dev.aurelium.auraskills.common.reward.parser.RewardParser;
import dev.aurelium.auraskills.common.reward.type.CommandReward;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.file.FileUtil;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RewardManager {
    protected final AuraSkillsPlugin plugin;
    private final Map<Skill, RewardTable> rewardTables;

    public RewardManager(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
        this.rewardTables = new ConcurrentHashMap<Skill, RewardTable>();
    }

    @NotNull
    public RewardTable getRewardTable(Skill skill) {
        return this.rewardTables.getOrDefault(skill, new RewardTable(this.plugin));
    }

    public void loadRewards() {
        this.clearRewardTables();
        File globalFile = new File(String.valueOf(this.plugin.getPluginFolder()) + "/rewards/global.yml");
        if (!globalFile.exists()) {
            this.plugin.saveResource("rewards/global.yml", false);
        }
        try {
            ConfigurationNode globalConfig = FileUtil.loadYamlFile(globalFile);
            int patternsLoaded = 0;
            int levelsLoaded = 0;
            int globalPatternsLoaded = 0;
            int globalLevelsLoaded = 0;
            for (Skill skill : this.plugin.getSkillManager().getSkillValues()) {
                File rewardsDirectory = this.getRewardsDir(skill);
                RewardTable rewardTable = new RewardTable(this.plugin);
                File rewardsFile = new File(String.valueOf(rewardsDirectory) + "/" + skill.name().toLowerCase(Locale.ROOT) + ".yml");
                if (!rewardsFile.exists()) {
                    if (skill instanceof CustomSkill) {
                        this.registerRewardTable(skill, rewardTable);
                        continue;
                    }
                    try {
                        this.plugin.saveResource("rewards/" + skill.name().toLowerCase(Locale.ROOT) + ".yml", false);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                ConfigurationNode rewardsConfig = FileUtil.loadYamlFile(rewardsFile);
                patternsLoaded += this.loadPatterns(skill, rewardTable, rewardsConfig.node("patterns"), rewardsFile, skill.getMaxLevel());
                int gpLoaded = this.loadPatterns(skill, rewardTable, globalConfig.node("patterns"), globalFile, skill.getMaxLevel());
                if (globalPatternsLoaded == 0) {
                    globalPatternsLoaded = gpLoaded;
                }
                levelsLoaded += this.loadLevels(skill, rewardTable, rewardsConfig, rewardsFile);
                int glLoaded = this.loadLevels(skill, rewardTable, globalConfig, globalFile);
                if (globalLevelsLoaded == 0) {
                    globalLevelsLoaded = glLoaded;
                }
                this.registerRewardTable(skill, rewardTable);
            }
            this.plugin.logger().info("Loaded " + (patternsLoaded += globalPatternsLoaded) + " pattern rewards and " + (levelsLoaded += globalLevelsLoaded) + " level rewards");
        }
        catch (IOException e) {
            this.plugin.logger().warn("Error loading rewards: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private int loadLevels(Skill skill, RewardTable rewardTable, ConfigurationNode rewardsConfig, File rewardsFile) {
        int levelsLoaded = 0;
        for (Map.Entry<Object, ? extends ConfigurationNode> entry : rewardsConfig.node("levels").childrenMap().entrySet()) {
            try {
                int level = entry.getKey() instanceof Integer ? (Integer)entry.getKey() : Integer.parseInt(String.valueOf(entry.getKey()));
                ConfigurationNode rewards = entry.getValue();
                List<? extends ConfigurationNode> rewardList = rewards.childrenList();
                for (int index = 0; index < rewardList.size(); ++index) {
                    ConfigurationNode rewardMap = rewardList.get(index);
                    try {
                        SkillReward reward = this.parseReward(rewardMap, skill);
                        if (reward == null) continue;
                        rewardTable.addReward(reward, level);
                        ++levelsLoaded;
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        this.plugin.logger().warn("Error while loading rewards file " + rewardsFile.getName() + " at path levels." + String.valueOf(entry.getKey()) + ".[" + index + "]: " + e.getMessage());
                    }
                }
            }
            catch (NumberFormatException e) {
                this.plugin.logger().warn("Error while loading rewards file " + rewardsFile.getName() + " at path levels." + String.valueOf(entry.getKey()) + ": Key " + String.valueOf(entry.getKey()) + " must be of type int");
            }
        }
        return levelsLoaded;
    }

    private File getRewardsDir(Skill skill) {
        if (skill instanceof CustomSkill) {
            CustomSkill customSkill = (CustomSkill)skill;
            NamespacedRegistry registry = this.plugin.getApi().getNamespacedRegistry(customSkill.getId().getNamespace());
            if (registry != null) {
                return new File(String.valueOf(registry.getContentDirectory()) + "/rewards");
            }
        }
        return new File(String.valueOf(this.plugin.getPluginFolder()) + "/rewards");
    }

    protected void clearRewardTables() {
        this.rewardTables.clear();
    }

    protected void registerRewardTable(Skill skill, RewardTable table) {
        this.rewardTables.put(skill, table);
    }

    protected int loadPatterns(Skill skill, RewardTable rewardTable, ConfigurationNode patterns, File rewardsFile, int maxLevel) {
        int patternsLoaded = 0;
        List<? extends ConfigurationNode> patternsList = patterns.childrenList();
        for (int index = 0; index < patternsList.size(); ++index) {
            ConfigurationNode rewardMap = patternsList.get(index);
            try {
                SkillReward reward = this.parseReward(rewardMap, skill);
                if (reward == null) continue;
                int start = rewardMap.node("pattern", "start").getInt(this.plugin.configInt(Option.START_LEVEL) + 1);
                int interval = rewardMap.node("pattern", "interval").getInt(1);
                int stop = rewardMap.node("pattern", "stop").getInt(maxLevel);
                if (stop > maxLevel) {
                    stop = maxLevel;
                }
                for (int level = start; level <= stop; level += interval) {
                    rewardTable.addReward(reward, level);
                }
                ++patternsLoaded;
                continue;
            }
            catch (IllegalArgumentException e) {
                this.plugin.logger().warn("Error while loading rewards file " + rewardsFile.getName() + " at path patterns.[" + index + "]: " + e.getMessage());
            }
        }
        return patternsLoaded;
    }

    @Nullable
    protected SkillReward parseReward(ConfigurationNode config, Skill skill) {
        String type = config.node("type").getString("");
        for (RewardType rewardType : RewardType.values()) {
            if (!rewardType.getKey().equalsIgnoreCase(type)) continue;
            try {
                Constructor<? extends RewardParser> constructor = rewardType.getParser().getConstructor(AuraSkillsPlugin.class, Skill.class);
                return constructor.newInstance(this.plugin, skill).parse(config);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        throw new IllegalArgumentException("Unrecognized reward type: " + type);
    }

    public List<Skill> getSkillsLeveledBy(Stat stat) {
        ArrayList<Skill> skillsLeveledBy = new ArrayList<Skill>();
        block0: for (Skill skill : this.plugin.getSkillRegistry().getValues()) {
            RewardTable table;
            if (!skill.isEnabled() || (table = this.rewardTables.get(skill)) == null) continue;
            for (Stat statLeveled : table.getStatsLeveled()) {
                if (!statLeveled.equals(stat)) continue;
                skillsLeveledBy.add(skill);
                continue block0;
            }
        }
        return skillsLeveledBy;
    }

    public void updatePermissions(User user) {
        if (user == null) {
            return;
        }
        for (Skill skill : this.plugin.getSkillManager().getSkillValues()) {
            this.plugin.getRewardManager().getRewardTable(skill).applyPermissions(user, user.getSkillLevel(skill));
        }
    }

    public void applyLevelUpCommands(User user, Skill skill, int oldLevel, int newLevel) {
        if (newLevel > oldLevel) {
            for (int i = oldLevel + 1; i <= newLevel; ++i) {
                for (CommandReward reward : this.plugin.getRewardManager().getRewardTable(skill).searchRewards(CommandReward.class, i)) {
                    reward.giveReward(user, skill, i);
                }
            }
        }
    }

    public void applyRevertCommands(User user, Skill skill, int oldLevel, int newLevel) {
        if (newLevel < oldLevel) {
            for (int i = oldLevel; i > newLevel; --i) {
                for (CommandReward reward : this.plugin.getRewardManager().getRewardTable(skill).searchRewards(CommandReward.class, i)) {
                    reward.executeRevert(user, skill, i);
                }
            }
        }
    }
}

