/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.region;

import com.google.common.base.Objects;
import dev.aurelium.auraskills.api.util.NumberUtil;
import org.jetbrains.annotations.NotNull;

public class BlockPosition {
    private final int x;
    private final int y;
    private final int z;

    public BlockPosition(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static BlockPosition fromCommaString(@NotNull String list) {
        String[] splitCoords = list.split(",");
        int x = 0;
        int y = 0;
        int z = 0;
        if (splitCoords.length == 3) {
            x = NumberUtil.toInt(splitCoords[0]);
            y = NumberUtil.toInt(splitCoords[1]);
            z = NumberUtil.toInt(splitCoords[2]);
        }
        return new BlockPosition(x, y, z);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockPosition)) {
            return false;
        }
        BlockPosition other = (BlockPosition)obj;
        return this.x == other.x && this.y == other.y && this.z == other.z;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.x, this.y, this.z});
    }

    public String toString() {
        return this.x + "," + this.y + "," + this.z;
    }
}

