/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.migration;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.aurelium.auraskills.api.ability.AbstractAbility;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.skill.Skills;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.api.util.AuraSkillsModifier;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.ability.AbilityData;
import dev.aurelium.auraskills.common.storage.sql.SqlStorageProvider;
import dev.aurelium.auraskills.common.util.data.KeyIntPair;
import dev.aurelium.auraskills.common.util.data.Pair;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class SqlUserMigrator {
    private final AuraSkillsPlugin plugin;
    private final SqlStorageProvider storageProvider;
    private final String tablePrefix = "auraskills_";

    public SqlUserMigrator(AuraSkillsPlugin plugin, SqlStorageProvider storageProvider) {
        this.plugin = plugin;
        this.storageProvider = storageProvider;
    }

    public void migrate() {
        try (Connection connection = this.storageProvider.getPool().getConnection();){
            if (!this.shouldMigrate(connection)) {
                return;
            }
            this.plugin.logger().warn("[Migrator] Attempting to migrate SQL user data from SkillData table to new tables");
            int rowsMigrated = 0;
            String skillDataQuery = "SELECT * FROM SkillData;";
            try (PreparedStatement statement = connection.prepareStatement(skillDataQuery);){
                ResultSet resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    try {
                        this.migrateRow(resultSet, connection);
                        ++rowsMigrated;
                    }
                    catch (SQLException e) {
                        this.plugin.logger().severe("[Migrator] Failed to migrate row with ID=" + resultSet.getString("ID"));
                    }
                }
            }
            this.plugin.logger().info("[Migrator] Migrated " + rowsMigrated + " rows from the table SkillData to the tables auraskills_users, auraskills_skill_levels, auraskills_key_values");
        }
        catch (SQLException e) {
            this.plugin.logger().severe("[Migrator] Error migrating SQL SkillData table to new tables");
            e.printStackTrace();
        }
    }

    private boolean shouldMigrate(Connection connection) {
        boolean bl;
        block8: {
            DatabaseMetaData dbm = connection.getMetaData();
            ResultSet tables = dbm.getTables(null, null, "SkillData", null);
            try {
                bl = tables.next();
                if (tables == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (tables != null) {
                        try {
                            tables.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.plugin.logger().warn("[Migrator] Failed to check SQL migration status");
                    e.printStackTrace();
                    return false;
                }
            }
            tables.close();
        }
        return bl;
    }

    private void migrateRow(ResultSet rs, Connection connection) throws SQLException {
        UUID playerUuid = UUID.fromString(rs.getString("ID"));
        String locale = rs.getString("LOCALE");
        double mana = rs.getDouble("MANA");
        String usersQuery = "INSERT IGNORE INTO auraskills_users (player_uuid, locale, mana) VALUES (?, ?, ?);";
        try (PreparedStatement statement = connection.prepareStatement(usersQuery);){
            statement.setString(1, playerUuid.toString());
            statement.setString(2, locale);
            statement.setDouble(3, mana);
            statement.executeUpdate();
        }
        int userId = this.storageProvider.getUserId(connection, playerUuid);
        String skillLevelsQuery = "INSERT IGNORE INTO auraskills_skill_levels (user_id, skill_name, skill_level, skill_xp) VALUES (?, ?, ?, ?)";
        try (PreparedStatement statement = connection.prepareStatement(skillLevelsQuery);){
            statement.setInt(1, userId);
            for (Map.Entry<Skill, Pair<Integer, Double>> entry : this.getOldSkillLevelsAndXp(rs).entrySet()) {
                String skillName = entry.getKey().getId().toString();
                int level = entry.getValue().first();
                double xp = entry.getValue().second();
                statement.setString(2, skillName);
                statement.setInt(3, level);
                statement.setDouble(4, xp);
                statement.executeUpdate();
            }
        }
        this.migrateStatModifiers(connection, rs, userId);
        this.migrateAbilityData(connection, rs, userId);
        this.migrateUnclaimedItems(connection, rs, userId);
    }

    private void migrateStatModifiers(Connection connection, ResultSet rs, int userId) throws SQLException {
        String statModifiersStr = rs.getString("STAT_MODIFIERS");
        List<StatModifier> modifiers = this.parseStatModifiers(statModifiersStr);
        String query = "INSERT IGNORE INTO auraskills_key_values (user_id, data_id, category_id, key_name, value) VALUES (?, ?, ?, ?, ?);";
        try (PreparedStatement statement = connection.prepareStatement(query);){
            statement.setInt(1, userId);
            statement.setInt(2, 1);
            for (StatModifier modifier : modifiers) {
                String categoryId = modifier.stat().getId().toString();
                statement.setString(3, categoryId);
                statement.setString(4, modifier.name());
                statement.setString(5, String.valueOf(modifier.value()));
                statement.executeUpdate();
            }
        }
    }

    private void migrateAbilityData(Connection connection, ResultSet rs, int userId) throws SQLException {
        String abilityDataStr = rs.getString("ABILITY_DATA");
        Map<AbstractAbility, AbilityData> abilityData = this.parseAbilityData(abilityDataStr);
        String query = "INSERT IGNORE INTO auraskills_key_values (user_id, data_id, category_id, key_name, value) VALUES (?, ?, ?, ?, ?);";
        try (PreparedStatement statement = connection.prepareStatement(query);){
            statement.setInt(1, userId);
            statement.setInt(2, 3);
            for (AbilityData data : abilityData.values()) {
                String categoryId = data.getAbility().getId().toString();
                statement.setString(3, categoryId);
                for (Map.Entry<String, Object> entry : data.getDataMap().entrySet()) {
                    statement.setString(4, entry.getKey());
                    statement.setString(5, String.valueOf(entry.getValue()));
                    statement.executeUpdate();
                }
            }
        }
    }

    private void migrateUnclaimedItems(Connection connection, ResultSet rs, int userId) throws SQLException {
        String unclaimedItemsStr = rs.getString("UNCLAIMED_ITEMS");
        List<KeyIntPair> unclaimedItems = this.parseUnclaimedItems(unclaimedItemsStr);
        String query = "INSERT IGNORE INTO auraskills_key_values (user_id, data_id, category_id, key_name, value) VALUES (?, ?, ?, ?, ?);";
        try (PreparedStatement statement = connection.prepareStatement(query);){
            statement.setInt(1, userId);
            statement.setInt(2, 4);
            for (KeyIntPair unclaimedItem : unclaimedItems) {
                statement.setNull(3, 12);
                statement.setString(4, unclaimedItem.getKey());
                statement.setString(5, String.valueOf(unclaimedItem.getValue()));
                statement.executeUpdate();
            }
        }
    }

    private Map<Skill, Pair<Integer, Double>> getOldSkillLevelsAndXp(ResultSet rs) throws SQLException {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)Skills.AGILITY, new Pair<Integer, Double>(rs.getInt("AGILITY_LEVEL"), rs.getDouble("AGILITY_XP")));
        builder.put((Object)Skills.ALCHEMY, new Pair<Integer, Double>(rs.getInt("ALCHEMY_LEVEL"), rs.getDouble("ALCHEMY_XP")));
        builder.put((Object)Skills.ARCHERY, new Pair<Integer, Double>(rs.getInt("ARCHERY_LEVEL"), rs.getDouble("ARCHERY_XP")));
        builder.put((Object)Skills.DEFENSE, new Pair<Integer, Double>(rs.getInt("DEFENSE_LEVEL"), rs.getDouble("DEFENSE_XP")));
        builder.put((Object)Skills.ENCHANTING, new Pair<Integer, Double>(rs.getInt("ENCHANTING_LEVEL"), rs.getDouble("ENCHANTING_XP")));
        builder.put((Object)Skills.ENDURANCE, new Pair<Integer, Double>(rs.getInt("ENDURANCE_LEVEL"), rs.getDouble("ENDURANCE_XP")));
        builder.put((Object)Skills.EXCAVATION, new Pair<Integer, Double>(rs.getInt("EXCAVATION_LEVEL"), rs.getDouble("EXCAVATION_XP")));
        builder.put((Object)Skills.FARMING, new Pair<Integer, Double>(rs.getInt("FARMING_LEVEL"), rs.getDouble("FARMING_XP")));
        builder.put((Object)Skills.FIGHTING, new Pair<Integer, Double>(rs.getInt("FIGHTING_LEVEL"), rs.getDouble("FIGHTING_XP")));
        builder.put((Object)Skills.FISHING, new Pair<Integer, Double>(rs.getInt("FISHING_LEVEL"), rs.getDouble("FISHING_XP")));
        builder.put((Object)Skills.FORAGING, new Pair<Integer, Double>(rs.getInt("FORAGING_LEVEL"), rs.getDouble("FORAGING_XP")));
        builder.put((Object)Skills.FORGING, new Pair<Integer, Double>(rs.getInt("FORGING_LEVEL"), rs.getDouble("FORGING_XP")));
        builder.put((Object)Skills.HEALING, new Pair<Integer, Double>(rs.getInt("HEALING_LEVEL"), rs.getDouble("HEALING_XP")));
        builder.put((Object)Skills.MINING, new Pair<Integer, Double>(rs.getInt("MINING_LEVEL"), rs.getDouble("MINING_XP")));
        builder.put((Object)Skills.SORCERY, new Pair<Integer, Double>(rs.getInt("SORCERY_LEVEL"), rs.getDouble("SORCERY_XP")));
        return builder.build();
    }

    private List<StatModifier> parseStatModifiers(String statModifiers) {
        ArrayList<StatModifier> list = new ArrayList<StatModifier>();
        if (statModifiers == null) {
            return list;
        }
        JsonArray jsonModifiers = (JsonArray)new Gson().fromJson(statModifiers, JsonArray.class);
        for (JsonElement modifierElement : jsonModifiers.getAsJsonArray()) {
            Stat stat;
            JsonObject modifierObject = modifierElement.getAsJsonObject();
            String name = modifierObject.get("name").getAsString();
            String statName = modifierObject.get("stat").getAsString();
            double value = modifierObject.get("value").getAsDouble();
            if (name == null || statName == null || (stat = (Stat)this.plugin.getStatRegistry().getOrNull(NamespacedId.fromDefault(statName.toLowerCase(Locale.ROOT)))) == null) continue;
            StatModifier modifier = new StatModifier(name, stat, value, AuraSkillsModifier.Operation.ADD);
            list.add(modifier);
        }
        return list;
    }

    private Map<AbstractAbility, AbilityData> parseAbilityData(String abilityData) {
        ConcurrentHashMap<AbstractAbility, AbilityData> map = new ConcurrentHashMap<AbstractAbility, AbilityData>();
        if (abilityData == null) {
            return map;
        }
        JsonObject jsonAbilityData = (JsonObject)new Gson().fromJson(abilityData, JsonObject.class);
        for (Map.Entry abilityEntry : jsonAbilityData.entrySet()) {
            String abilityName = (String)abilityEntry.getKey();
            AbstractAbility ability = this.plugin.getAbilityManager().getAbstractAbility(NamespacedId.fromDefault(abilityName.toLowerCase(Locale.ROOT)));
            if (ability == null) continue;
            AbilityData data = new AbilityData(ability);
            JsonObject dataObject = ((JsonElement)abilityEntry.getValue()).getAsJsonObject();
            for (Map.Entry dataEntry : dataObject.entrySet()) {
                Object value;
                String key = (String)dataEntry.getKey();
                JsonElement element = (JsonElement)dataEntry.getValue();
                if (!element.isJsonPrimitive() || (value = this.parsePrimitive(((JsonElement)dataEntry.getValue()).getAsJsonPrimitive())) == null) continue;
                data.setData(key, value);
            }
            if (data.getDataMap().isEmpty()) continue;
            map.put(ability, data);
        }
        return map;
    }

    private List<KeyIntPair> parseUnclaimedItems(String input) {
        String[] splitString;
        if (input == null) {
            return new ArrayList<KeyIntPair>();
        }
        ArrayList<KeyIntPair> unclaimedItems = new ArrayList<KeyIntPair>();
        for (String entry : splitString = input.split(",")) {
            String[] splitEntry = entry.split(" ");
            String itemKey = splitEntry[0];
            int amount = 1;
            if (splitEntry.length >= 2) {
                amount = NumberUtil.toInt(splitEntry[1], 1);
            }
            unclaimedItems.add(new KeyIntPair(itemKey, amount));
        }
        return unclaimedItems;
    }

    private Object parsePrimitive(JsonPrimitive primitive) {
        if (primitive.isBoolean()) {
            return primitive.getAsBoolean();
        }
        if (primitive.isString()) {
            return primitive.getAsString();
        }
        if (primitive.isNumber()) {
            if (primitive.getAsDouble() % 1.0 != 0.0) {
                return primitive.getAsDouble();
            }
            return primitive.getAsInt();
        }
        return null;
    }
}

