/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.message;

import dev.aurelium.auraskills.acf.CommandIssuer;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.hooks.PlaceholderHook;
import dev.aurelium.auraskills.common.message.MessageKey;
import dev.aurelium.auraskills.common.message.recipient.CommandIssuerRecipient;
import dev.aurelium.auraskills.common.message.recipient.UserRecipient;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import dev.aurelium.auraskills.kyori.adventure.text.Component;
import dev.aurelium.auraskills.kyori.adventure.text.TextComponent;
import dev.aurelium.auraskills.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class MessageBuilder {
    private final AuraSkillsPlugin plugin;
    private Locale locale;
    private TextComponent component;

    private MessageBuilder(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
        this.component = Component.empty();
    }

    public static MessageBuilder create(AuraSkillsPlugin plugin) {
        return new MessageBuilder(plugin);
    }

    public void send(User user) {
        this.validateComponent(user);
        new UserRecipient(user).sendMessage(this.component);
    }

    public void send(CommandIssuer issuer) {
        if (issuer.isPlayer()) {
            User user = this.plugin.getUserManager().getUser(issuer.getUniqueId());
            this.validateComponent(user);
        } else {
            this.validateComponent(null);
        }
        new CommandIssuerRecipient(this.plugin, issuer).sendMessage(this.component);
    }

    public MessageBuilder locale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public MessageBuilder text(TextComponent text) {
        this.component = (TextComponent)this.component.append(text);
        return this;
    }

    public MessageBuilder text(String text) {
        this.component = (TextComponent)this.component.append(this.toComponent(text));
        return this;
    }

    public MessageBuilder prefix() {
        if (this.locale == null) {
            throw new IllegalStateException("Cannot add prefix because locale is null");
        }
        String prefix = this.plugin.getPrefix(this.locale);
        this.component = (TextComponent)this.component.append(this.toComponent(prefix));
        return this;
    }

    public MessageBuilder message(MessageKey key, String ... rep) {
        return this.message(key, false, rep);
    }

    public MessageBuilder rawMessage(MessageKey key, String ... rep) {
        return this.message(key, true, rep);
    }

    public MessageBuilder message(MessageKey key, boolean raw, String ... rep) {
        String message;
        if (this.locale == null) {
            throw new IllegalStateException("Cannot add message because locale is null");
        }
        String string = message = raw ? this.plugin.getMessageProvider().getRaw(key, this.locale) : this.plugin.getMsg(key, this.locale);
        if (rep.length % 2 != 0) {
            throw new IllegalArgumentException("Replacements must be even");
        }
        for (int i = 0; i < rep.length; i += 2) {
            message = TextUtil.replace(message, "{" + rep[i] + "}", rep[i + 1]);
        }
        this.component = (TextComponent)this.component.append(this.toComponent(message));
        return this;
    }

    private TextComponent toComponent(String text) {
        return LegacyComponentSerializer.legacySection().deserialize(text);
    }

    public String toString() {
        return LegacyComponentSerializer.legacySection().serialize(this.component);
    }

    private void validateComponent(@Nullable User user) {
        if (this.component == null) {
            throw new IllegalStateException("Cannot send message because text component is null");
        }
        if (this.plugin.getHookManager().isRegistered(PlaceholderHook.class) && user != null) {
            String text = this.toString();
            text = this.plugin.getHookManager().getHook(PlaceholderHook.class).setPlaceholders(user, text);
            this.component = this.toComponent(text);
        }
    }
}

