/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.mana;

import dev.aurelium.auraskills.api.mana.ManaAbilities;
import dev.aurelium.auraskills.api.mana.ManaAbility;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.config.ConfigurateLoader;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.mana.LoadedManaAbility;
import dev.aurelium.auraskills.common.mana.ManaAbilityConfig;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.configurate.serialize.SerializationException;
import dev.aurelium.auraskills.configurate.serialize.TypeSerializerCollection;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ManaAbilityLoader {
    private static final String FILE_NAME = "mana_abilities.yml";
    private final AuraSkillsPlugin plugin;
    private final ConfigurateLoader configurateLoader;
    private ConfigurationNode root;

    public ManaAbilityLoader(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
        TypeSerializerCollection abilitySerializers = TypeSerializerCollection.builder().build();
        this.configurateLoader = new ConfigurateLoader(plugin, abilitySerializers);
    }

    public void init() {
        try {
            this.configurateLoader.updateUserFile(FILE_NAME);
            ConfigurationNode embedded = this.configurateLoader.loadEmbeddedFile(FILE_NAME);
            ConfigurationNode defined = this.plugin.getManaAbilityRegistry().getDefinedConfig();
            ConfigurationNode user = this.configurateLoader.loadUserFile(FILE_NAME);
            this.root = this.configurateLoader.loadContentAndMerge(defined, FILE_NAME, embedded, user);
        }
        catch (IOException e) {
            this.plugin.logger().warn("Error loading mana_abilities.yml file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public LoadedManaAbility loadManaAbility(ManaAbility manaAbility, Skill skill) throws SerializationException {
        ConfigurationNode abilityNode = this.root.node("mana_abilities", manaAbility.getId().toString());
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        for (Object key : abilityNode.childrenMap().keySet()) {
            configMap.put((String)key, abilityNode.node(key).raw());
        }
        this.applyConfigOverrides(manaAbility, configMap);
        ManaAbilityConfig abilityConfig = new ManaAbilityConfig(configMap);
        return new LoadedManaAbility(manaAbility, skill, abilityConfig);
    }

    private void applyConfigOverrides(ManaAbility ma, Map<String, Object> configMap) {
        if (this.plugin.configBoolean(Option.MANA_ENABLED)) {
            return;
        }
        if (ma == ManaAbilities.ABSORPTION || ma == ManaAbilities.CHARGED_SHOT) {
            configMap.put("enabled", false);
        }
    }
}

