/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.loot;

import dev.aurelium.auraskills.api.loot.Loot;
import dev.aurelium.auraskills.api.loot.LootParser;
import dev.aurelium.auraskills.api.loot.LootPool;
import dev.aurelium.auraskills.api.loot.LootTable;
import dev.aurelium.auraskills.api.loot.LootTableType;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.registry.NamespacedRegistry;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.api.ApiAuraSkills;
import dev.aurelium.auraskills.common.api.implementation.ApiConfigNode;
import dev.aurelium.auraskills.common.config.ConfigurateLoader;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.loot.LootManager;
import dev.aurelium.auraskills.common.loot.LootParsingContextImpl;
import dev.aurelium.auraskills.common.loot.LootType;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.configurate.serialize.TypeSerializerCollection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public abstract class LootLoader {
    private final AuraSkillsPlugin plugin;
    private final LootManager manager;

    public LootLoader(AuraSkillsPlugin plugin, LootManager lootManager) {
        this.plugin = plugin;
        this.manager = lootManager;
    }

    public abstract LootParser getParser(LootType var1);

    public void loadLootTables() {
        boolean convertFishing = !new File(String.valueOf(this.plugin.getPluginFolder()) + "/loot", "fishing.yml").exists();
        boolean convertExcavation = !new File(String.valueOf(this.plugin.getPluginFolder()) + "/loot", "excavation.yml").exists();
        File lootDirectory = new File(String.valueOf(this.plugin.getPluginFolder()) + "/loot");
        if (!lootDirectory.exists() || convertFishing || convertExcavation) {
            this.generateDefaultLootTables();
        }
        if (!lootDirectory.isDirectory()) {
            return;
        }
        this.manager.getLootTables().clear();
        File[] files = lootDirectory.listFiles();
        if (files == null) {
            return;
        }
        for (File lootTableFile : files) {
            if (!lootTableFile.isFile() || !lootTableFile.getName().endsWith(".yml")) continue;
            ConfigurateLoader loader = new ConfigurateLoader(this.plugin, TypeSerializerCollection.builder().build());
            try {
                String fileName;
                NamespacedId id;
                LootTable lootTable;
                ConfigurationNode user;
                ConfigurationNode config = user = loader.loadUserFile(lootTableFile);
                String path = this.plugin.getPluginFolder().toPath().relativize(lootTableFile.toPath()).toString();
                ConfigurationNode embedded = null;
                if (this.plugin.getResource(path) != null) {
                    embedded = loader.loadEmbeddedFile(path);
                    if (this.plugin.configBoolean(Option.LOOT_UPDATE_LOOT_TABLES)) {
                        config = loader.mergeNodes(embedded, user);
                    }
                }
                if ((lootTable = this.loadLootTable(id = NamespacedId.fromDefault(fileName = lootTableFile.getName().replace(".yml", "")), lootTableFile, config)) == null) continue;
                this.manager.addLootTable(id, lootTable);
                if (embedded == null) continue;
                loader.saveConfigIfUpdated(lootTableFile, embedded, user, config);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.loadCustomLootTables();
        int tablesLoaded = 0;
        int poolsLoaded = 0;
        int lootLoaded = 0;
        for (LootTable table : this.manager.getLootTables().values()) {
            for (LootPool pool : table.getPools()) {
                ++poolsLoaded;
                lootLoaded += pool.getLoot().size();
            }
            ++tablesLoaded;
        }
        this.plugin.logger().info("Loaded " + lootLoaded + " loot entries in " + poolsLoaded + " pools and " + tablesLoaded + " tables");
    }

    private LootTable loadLootTable(NamespacedId id, File file, ConfigurationNode config) {
        ConfigurationNode poolsNode;
        String typeString = config.node("type").getString();
        LootTableType type = LootTableType.BLOCK;
        if (typeString != null) {
            type = LootTableType.valueOf(typeString.toUpperCase(Locale.ROOT));
        }
        if ((poolsNode = config.node("pools")).virtual()) {
            return null;
        }
        ArrayList<LootPool> pools = new ArrayList<LootPool>();
        for (ConfigurationNode configurationNode : poolsNode.childrenMap().values()) {
            String poolName = (String)configurationNode.key();
            double baseChance = configurationNode.node("base_chance").getDouble(0.0) / 100.0;
            int selectionPriority = configurationNode.node("selection_priority").getInt(1);
            boolean overrideVanillaLoot = configurationNode.node("override_vanilla_loot").getBoolean(false);
            ConcurrentHashMap<String, Object> options = new ConcurrentHashMap<String, Object>();
            for (String optionKey : this.manager.getPoolOptionKeys()) {
                if (!configurationNode.hasChild(optionKey)) continue;
                Object option = configurationNode.node(optionKey).raw();
                options.put(optionKey, option);
            }
            ArrayList<Loot> lootList = new ArrayList<Loot>();
            int index = 0;
            for (ConfigurationNode configurationNode2 : configurationNode.node("loot").childrenList()) {
                Loot loot = null;
                try {
                    String lootTypeName = configurationNode2.node("type").getString("");
                    LootType lootType = LootType.valueOf(lootTypeName.toUpperCase(Locale.ROOT));
                    LootParsingContextImpl context = new LootParsingContextImpl(this.manager);
                    if (lootType == LootType.ITEM) {
                        int ignoreBelow = configurationNode2.node("ignore_below").getInt(-1);
                        if (ignoreBelow != -1 && !this.manager.getPlugin().isAtLeastVersion(ignoreBelow)) {
                            ++index;
                            continue;
                        }
                        loot = this.getParser(lootType).parse(context, ApiConfigNode.toApi(configurationNode2), this.manager.getLootRequirements(configurationNode2));
                    } else if (lootType == LootType.COMMAND) {
                        loot = this.getParser(lootType).parse(context, ApiConfigNode.toApi(configurationNode2), this.manager.getLootRequirements(configurationNode2));
                    } else if (lootType == LootType.ENTITY) {
                        loot = this.getParser(lootType).parse(context, ApiConfigNode.toApi(configurationNode2), this.manager.getLootRequirements(configurationNode2));
                    } else {
                        LootParser customParser = this.manager.getCustomLootParsers().get(lootTypeName);
                        if (customParser == null) {
                            throw new IllegalArgumentException("Unknown loot type: " + lootTypeName);
                        }
                        loot = customParser.parse(context, ApiConfigNode.toApi(configurationNode2), this.manager.getLootRequirements(configurationNode2));
                    }
                }
                catch (Exception e) {
                    this.manager.getPlugin().logger().warn("Error parsing loot in file loot/" + file.getName() + " at path pools." + poolName + ".loot." + index + ", see below for error:");
                    e.printStackTrace();
                }
                if (loot != null) {
                    lootList.add(loot);
                }
                ++index;
            }
            LootPool pool = new LootPool(poolName, lootList, baseChance, selectionPriority, overrideVanillaLoot, options, this.manager.getLootRequirements(configurationNode));
            pools.add(pool);
        }
        pools.sort((pool1, pool2) -> pool2.getSelectionPriority() - pool1.getSelectionPriority());
        return new LootTable(id, UUID.randomUUID(), type, pools, this.manager.getLootRequirements(config));
    }

    private void generateDefaultLootTables() {
        File excavationFile;
        File fishingFile = new File(String.valueOf(this.plugin.getPluginFolder()) + "/loot", "fishing.yml");
        if (!fishingFile.exists()) {
            this.plugin.saveResource("loot/fishing.yml", false);
        }
        if (!(excavationFile = new File(String.valueOf(this.plugin.getPluginFolder()) + "/loot", "excavation.yml")).exists()) {
            this.plugin.saveResource("loot/excavation.yml", false);
        }
    }

    private void loadCustomLootTables() {
        ApiAuraSkills api = (ApiAuraSkills)this.plugin.getApi();
        for (NamespacedRegistry registry : api.getNamespacedRegistryMap().values()) {
            registry.getLootDirectory().ifPresent(dir -> this.loadExternalLootDir((File)dir, registry));
        }
    }

    private void loadExternalLootDir(File dir, NamespacedRegistry registry) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File lootTableFile : files) {
            if (!lootTableFile.isFile() || !lootTableFile.getName().endsWith(".yml")) continue;
            ConfigurateLoader loader = new ConfigurateLoader(this.plugin, TypeSerializerCollection.builder().build());
            try {
                ConfigurationNode config = loader.loadUserFile(lootTableFile);
                String fileName = lootTableFile.getName().replace(".yml", "");
                NamespacedId id = NamespacedId.of(registry.getNamespace(), fileName);
                LootTable lootTable = this.loadLootTable(id, lootTableFile, config);
                if (lootTable == null) continue;
                this.manager.addLootTable(id, lootTable);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

