/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.level;

import com.google.common.collect.ImmutableList;
import dev.aurelium.auraskills.api.ability.Ability;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.source.XpSource;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.hooks.EconomyHook;
import dev.aurelium.auraskills.common.jobs.JobsBatchData;
import dev.aurelium.auraskills.common.level.LevelUpMessenger;
import dev.aurelium.auraskills.common.level.XpRequirements;
import dev.aurelium.auraskills.common.reward.SkillReward;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.data.Pair;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LevelManager {
    private final AuraSkillsPlugin plugin;
    protected final XpRequirements xpRequirements;

    public LevelManager(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
        this.xpRequirements = plugin.getXpRequirements();
    }

    public double getPermissionMultiplier(@NotNull User user, @Nullable Skill skill) {
        return user.getPermissionMultiplier(skill);
    }

    public double getAbilityMultiplier(User user, Skill skill) {
        Ability ability = skill.getXpMultiplierAbility();
        double multiplier = 1.0;
        if (ability != null && user.getAbilityLevel(ability) > 0) {
            double abilityValue = ability.getValue(user.getAbilityLevel(ability));
            double addedMultiplier = abilityValue / 100.0;
            multiplier += addedMultiplier;
        }
        return multiplier;
    }

    public abstract void playLevelUpSound(@NotNull User var1);

    public void addXp(User user, Skill skill, @Nullable XpSource source, double amount) {
        if (amount == 0.0) {
            return;
        }
        double amountToAdd = amount * this.calculateMultiplier(user, skill);
        Pair<Boolean, Double> res = this.plugin.getEventHandler().callXpGainEvent(user, skill, source, amountToAdd);
        if (res.first().booleanValue()) {
            return;
        }
        this.addXpRaw(user, skill, res.second(), source);
    }

    protected void addXpRaw(User user, Skill skill, double amount, @Nullable XpSource xpSource) {
        if (amount <= 0.0) {
            return;
        }
        double income = this.addJobsIncome(user, skill, amount, xpSource);
        user.addSkillXp(skill, amount);
        this.checkLevelUp(user, skill);
        this.sendXpUi(user, skill, amount, income);
    }

    private double addJobsIncome(User user, Skill skill, double amount, @Nullable XpSource source) {
        double income;
        if (source == null) {
            return 0.0;
        }
        if (!this.plugin.configBoolean(Option.JOBS_ENABLED)) {
            return 0.0;
        }
        if (this.plugin.config().jobSelectionEnabled() && !user.getJobs().contains(skill)) {
            return 0.0;
        }
        if (!this.plugin.getHookManager().isRegistered(EconomyHook.class)) {
            return 0.0;
        }
        double originalIncome = income = source.getIncome().getIncomeEarned(user.toApi(), source.getValues(), skill, amount);
        boolean displayIndividual = false;
        if (this.plugin.configBoolean(Option.JOBS_INCOME_BATCHING_ENABLED)) {
            income = this.handleBatching(user, income);
            displayIndividual = this.plugin.configBoolean(Option.JOBS_INCOME_BATCHING_DISPLAY_INDIVIDUAL);
        }
        if (income > 0.0 && this.plugin.getHookManager().isRegistered(EconomyHook.class)) {
            EconomyHook economy = this.plugin.getHookManager().getHook(EconomyHook.class);
            economy.deposit(user, income);
        }
        if (displayIndividual) {
            return originalIncome;
        }
        return income;
    }

    private double handleBatching(User user, double income) {
        JobsBatchData batchData = user.getJobsBatchData();
        int interval = this.plugin.configInt(Option.JOBS_INCOME_BATCHING_INTERVAL_MS);
        long lastAdd = batchData.getLastAddTime();
        long now = System.currentTimeMillis();
        if (now > lastAdd + (long)interval) {
            double toAdd = batchData.getAccumulatedIncome() + income;
            batchData.setAccumulatedIncome(0.0);
            batchData.setLastAddTime(now);
            return toAdd;
        }
        batchData.addAccumulatedIncome(income);
        return 0.0;
    }

    public void setXp(User user, Skill skill, double amount) {
        double originalAmount = user.getSkillXp(skill);
        user.setSkillXp(skill, amount);
        this.checkLevelUp(user, skill);
        double xpAmount = amount - originalAmount;
        this.sendXpUi(user, skill, xpAmount, 0.0);
    }

    private void sendXpUi(User user, Skill skill, double xpGained, double income) {
        double currentXp = user.getSkillXp(skill);
        int level = user.getSkillLevel(skill);
        double levelXp = this.xpRequirements.getXpRequired(skill, level + 1);
        boolean maxed = this.xpRequirements.getListSize(skill) <= user.getSkillLevel(skill) - 1 || level >= skill.getMaxLevel();
        this.plugin.getUiProvider().getActionBarManager().sendXpActionBar(user, skill, currentXp, levelXp, xpGained, level, maxed, income);
        if (this.plugin.configBoolean(Option.BOSS_BAR_ENABLED)) {
            this.plugin.getUiProvider().sendXpBossBar(user, skill, currentXp, levelXp, xpGained, level, maxed, income);
        }
    }

    public void checkLevelUp(User user, Skill skill) {
        int currentLevel = user.getSkillLevel(skill);
        double currentXp = user.getSkillXp(skill);
        if (currentLevel >= skill.getMaxLevel()) {
            return;
        }
        if (this.xpRequirements.getListSize(skill) <= currentLevel - 1) {
            return;
        }
        if (currentXp >= (double)this.xpRequirements.getXpRequired(skill, currentLevel + 1)) {
            this.levelUpSkill(user, skill);
        }
    }

    private void levelUpSkill(User user, Skill skill) {
        Locale locale = user.getLocale();
        double currentXp = user.getSkillXp(skill);
        int level = user.getSkillLevel(skill) + 1;
        user.setSkillXp(skill, currentXp - (double)this.xpRequirements.getXpRequired(skill, level));
        user.setSkillLevel(skill, level);
        ImmutableList<SkillReward> rewards = this.plugin.getRewardManager().getRewardTable(skill).getRewards(level);
        for (SkillReward reward : rewards) {
            reward.giveReward(user, skill, level);
        }
        this.plugin.getModifierManager().applyModifiers(user, true);
        this.plugin.getEventHandler().callSkillLevelUpEvent(user, skill, level);
        LevelUpMessenger messenger = new LevelUpMessenger(this.plugin, user, locale, skill, level, (List<SkillReward>)rewards);
        if (this.plugin.configBoolean(Option.LEVELER_TITLE_ENABLED)) {
            messenger.sendTitle();
        }
        if (this.plugin.configBoolean(Option.LEVELER_SOUND_ENABLED)) {
            this.playLevelUpSound(user);
        }
        messenger.sendChatMessage();
        this.plugin.getScheduler().scheduleSync(() -> this.checkLevelUp(user, skill), 50L * (long)this.plugin.configInt(Option.LEVELER_DOUBLE_CHECK_DELAY), TimeUnit.MILLISECONDS);
    }

    public double calculateMultiplier(@NotNull User user, Skill skill) {
        double multiplier = 1.0;
        multiplier += this.getItemMultiplier(user, skill);
        return this.getAbilityMultiplier(user, skill) * (multiplier += this.getPermissionMultiplier(user, skill));
    }

    public double getGenericMultiplier(User user) {
        double multiplier = 1.0;
        multiplier += this.getItemMultiplier(user, null);
        return multiplier += this.getPermissionMultiplier(user, null);
    }

    public double getItemMultiplier(@NotNull User user, @Nullable Skill skill) {
        return user.getTotalMultiplier(skill) / 100.0;
    }
}

