/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.leaderboard;

import com.google.common.collect.Sets;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.util.file.FileUtil;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public abstract class LeaderboardExclusion {
    public static final String FILE_PATH = ".metadata/leaderboard_metadata.yml";
    protected final AuraSkillsPlugin plugin;
    private final Set<UUID> excludedPlayers = Sets.newConcurrentHashSet();

    public LeaderboardExclusion(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean isExcludedPlayer(UUID uuid) {
        return this.excludedPlayers.contains(uuid);
    }

    public void addExcludedPlayer(UUID uuid) {
        this.excludedPlayers.add(uuid);
    }

    public void removeExcludedPlayer(UUID uuid) {
        this.excludedPlayers.remove(uuid);
    }

    public void loadFromFile() {
        File file = new File(this.plugin.getPluginFolder(), FILE_PATH);
        try {
            ConfigurationNode config = FileUtil.loadYamlFile(file);
            List<String> excluded = config.node("excluded_players").getList(String.class, new ArrayList());
            this.excludedPlayers.clear();
            this.excludedPlayers.addAll(excluded.stream().map(UUID::fromString).toList());
        }
        catch (IOException e) {
            this.plugin.logger().warn("Error loading .metadata/leaderboard_metadata.yml");
            e.printStackTrace();
        }
    }

    public void saveToFile() {
        File file = new File(this.plugin.getPluginFolder(), FILE_PATH);
        try {
            ConfigurationNode config = FileUtil.loadYamlFile(file);
            if (this.excludedPlayers.isEmpty() && config.node("excluded_players").getList(String.class, new ArrayList()).isEmpty()) {
                return;
            }
            config.node("excluded_players").set(this.excludedPlayers.stream().map(UUID::toString).toList());
            FileUtil.saveYamlFile(file, config);
        }
        catch (IOException e) {
            this.plugin.logger().warn("Error saving .metadata/leaderboard_metadata.yml");
            e.printStackTrace();
        }
    }
}

