/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.hooks;

import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.hooks.Hook;
import dev.aurelium.auraskills.common.hooks.HookManager;
import dev.aurelium.auraskills.common.hooks.HookRegistrationException;
import dev.aurelium.auraskills.common.hooks.HookType;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class HookRegistrar {
    private final AuraSkillsPlugin plugin;
    private final HookManager manager;

    public HookRegistrar(AuraSkillsPlugin plugin, HookManager manager) {
        this.plugin = plugin;
        this.manager = manager;
    }

    public abstract void registerEvents(Hook var1);

    public abstract boolean isPluginEnabled(String var1);

    public abstract boolean isPluginLoaded(String var1);

    public void registerHooks(ConfigurationNode config, HookType[] hooks) {
        for (HookType hookType : hooks) {
            if (this.manager.isRegistered(hookType.getHookClass()) || (hookType.requiresEnabledFirst() ? !this.isPluginEnabled(hookType.getPluginName()) : !this.isPluginLoaded(hookType.getPluginName()))) continue;
            try {
                ConfigurationNode hookConfig = config.node(hookType.getPluginName());
                if (!hookConfig.node("enabled").getBoolean(false)) continue;
                Hook hook = this.createHook(hookType, hookConfig);
                this.registerEvents(hook);
                this.manager.registerHook(hook.getClass(), hook);
                this.plugin.logger().info("Successfully registered hook " + hookType.getPluginName());
            }
            catch (HookRegistrationException e) {
                this.plugin.logger().warn("Failed to register hook " + hookType.getPluginName() + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    protected Hook createHook(HookType type, ConfigurationNode config) {
        Class<? extends Hook> hookClass = type.getHookClass();
        Constructor<?>[] constructors = hookClass.getDeclaredConstructors();
        if (constructors.length == 0) {
            throw new HookRegistrationException("Hook does not have a declared constructor");
        }
        Constructor<?> constructor = constructors[0];
        if (constructor == null) {
            throw new HookRegistrationException("Hook does not have a declared constructor");
        }
        try {
            return (Hook)constructor.newInstance(this.plugin, config);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            throw new HookRegistrationException("Failed to construct hook using reflection: " + e.getMessage());
        }
    }
}

