/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.hooks;

import dev.aurelium.auraskills.common.hooks.Hook;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HookManager {
    private final Map<Class<? extends Hook>, Hook> hooks = new ConcurrentHashMap<Class<? extends Hook>, Hook>();

    public boolean isRegistered(Class<? extends Hook> type) {
        if (this.hooks.containsKey(type)) {
            return true;
        }
        for (Class<? extends Hook> clazz : this.hooks.keySet()) {
            if (!type.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public <T extends Hook> T getHook(Class<T> type) {
        Hook hook = this.hooks.get(type);
        if (hook == null) {
            for (Class<? extends Hook> clazz : this.hooks.keySet()) {
                if (!type.isAssignableFrom(clazz)) continue;
                hook = this.hooks.get(clazz);
            }
            if (hook == null) {
                throw new IllegalArgumentException("No registered hook of type " + type.getName() + "!");
            }
        }
        return (T)((Hook)type.cast(hook));
    }

    public void registerHook(Class<? extends Hook> type, Hook hook) {
        this.hooks.put(type, hook);
    }
}

