/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.api;

import dev.aurelium.auraskills.api.AuraSkillsApi;
import dev.aurelium.auraskills.api.config.MainConfig;
import dev.aurelium.auraskills.api.loot.LootManager;
import dev.aurelium.auraskills.api.message.MessageManager;
import dev.aurelium.auraskills.api.registry.GlobalRegistry;
import dev.aurelium.auraskills.api.registry.Handlers;
import dev.aurelium.auraskills.api.registry.NamespacedRegistry;
import dev.aurelium.auraskills.api.skill.XpRequirements;
import dev.aurelium.auraskills.api.source.SourceManager;
import dev.aurelium.auraskills.api.user.SkillsUser;
import dev.aurelium.auraskills.api.user.UserManager;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.api.implementation.ApiGlobalRegistry;
import dev.aurelium.auraskills.common.api.implementation.ApiHandlers;
import dev.aurelium.auraskills.common.api.implementation.ApiMainConfig;
import dev.aurelium.auraskills.common.api.implementation.ApiMessageManager;
import dev.aurelium.auraskills.common.api.implementation.ApiNamespacedRegistry;
import dev.aurelium.auraskills.common.api.implementation.ApiSourceManager;
import dev.aurelium.auraskills.common.api.implementation.ApiUserManager;
import dev.aurelium.auraskills.common.api.implementation.ApiXpRequirements;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class ApiAuraSkills
implements AuraSkillsApi {
    private final AuraSkillsPlugin plugin;
    private final UserManager userManager;
    private final MessageManager messageManager;
    private final XpRequirements xpRequirements;
    private final Map<String, NamespacedRegistry> namespacedRegistryMap;
    private final Handlers handlers;
    private final MainConfig mainConfig;
    private final GlobalRegistry globalRegistry;
    private final SourceManager sourceManager;

    public ApiAuraSkills(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
        this.userManager = new ApiUserManager(plugin);
        this.messageManager = new ApiMessageManager(plugin);
        this.xpRequirements = new ApiXpRequirements(plugin);
        this.namespacedRegistryMap = new ConcurrentHashMap<String, NamespacedRegistry>();
        this.handlers = new ApiHandlers(plugin);
        this.mainConfig = new ApiMainConfig(plugin);
        this.globalRegistry = new ApiGlobalRegistry(plugin);
        this.sourceManager = new ApiSourceManager(plugin);
    }

    public AuraSkillsPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public SkillsUser getUser(UUID playerId) {
        return this.userManager.getUser(playerId);
    }

    @Override
    public UserManager getUserManager() {
        return this.userManager;
    }

    @Override
    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    @Override
    public XpRequirements getXpRequirements() {
        return this.xpRequirements;
    }

    @Override
    public GlobalRegistry getGlobalRegistry() {
        return this.globalRegistry;
    }

    @Override
    public NamespacedRegistry useRegistry(String namespace, File contentDirectory) {
        if ((namespace = namespace.toLowerCase(Locale.ROOT)).equals("auraskills")) {
            throw new IllegalArgumentException("Cannot get a namespaced registry for auraskills, use the name of your plugin!");
        }
        String finalNamespace = namespace;
        return this.namespacedRegistryMap.computeIfAbsent(namespace, s -> {
            this.plugin.getSkillManager().addContentDirectory(contentDirectory);
            return new ApiNamespacedRegistry(this.plugin, finalNamespace, contentDirectory);
        });
    }

    @Override
    @Nullable
    public NamespacedRegistry getNamespacedRegistry(String namespace) {
        return this.namespacedRegistryMap.get(namespace);
    }

    @Override
    public Handlers getHandlers() {
        return this.handlers;
    }

    @Override
    public MainConfig getMainConfig() {
        return this.mainConfig;
    }

    @Override
    public SourceManager getSourceManager() {
        return this.sourceManager;
    }

    @Override
    public LootManager getLootManager() {
        return this.plugin.getApiProvider().getLootManager();
    }

    public Map<String, NamespacedRegistry> getNamespacedRegistryMap() {
        return this.namespacedRegistryMap;
    }
}

