/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.antiafk;

import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.antiafk.Check;
import dev.aurelium.auraskills.common.antiafk.CheckData;
import dev.aurelium.auraskills.common.antiafk.CheckType;
import dev.aurelium.auraskills.common.antiafk.LogLocation;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.message.type.CommandMessage;
import dev.aurelium.auraskills.common.ref.PlayerRef;
import dev.aurelium.auraskills.common.user.AntiAfkLog;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import dev.aurelium.auraskills.evalex.Expression;
import dev.aurelium.auraskills.evalex.parser.ParseException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AntiAfkManager {
    private final AuraSkillsPlugin plugin;
    private final Map<CheckType, Check> checkMap = new ConcurrentHashMap<CheckType, Check>();
    private Expression logThresholdExpression;

    public AntiAfkManager(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
        if (!plugin.configBoolean(Option.ANTI_AFK_ENABLED)) {
            return;
        }
        this.loadLogThresholdExpression();
    }

    public abstract void registerCheckEvents(Check var1);

    public abstract void unregisterCheckEvents(Check var1);

    public abstract LogLocation getLogLocation(PlayerRef var1);

    protected abstract Constructor<?> getCheckConstructor(Class<? extends Check> var1) throws NoSuchMethodException;

    public Optional<Check> getCheck(CheckType type) {
        return Optional.ofNullable(this.checkMap.get(type));
    }

    public CheckData getCheckData(PlayerRef ref, CheckType type) {
        return this.plugin.getUser(ref).getCheckData(type);
    }

    public abstract CheckType[] getCheckTypes();

    public AuraSkillsPlugin getPlugin() {
        return this.plugin;
    }

    public Expression getLogThresholdExpression() {
        return this.logThresholdExpression;
    }

    public void reload() {
        this.loadLogThresholdExpression();
        for (Check existing : this.checkMap.values()) {
            this.unregisterCheckEvents(existing);
        }
        this.checkMap.clear();
        if (!this.plugin.configBoolean(Option.ANTI_AFK_ENABLED)) {
            return;
        }
        this.registerChecks();
    }

    public void logAndNotifyFail(PlayerRef ref, CheckType checkType, CheckData checkData) {
        User user = this.plugin.getUser(ref);
        String message = TextUtil.replace(this.plugin.getMsg(CommandMessage.ANTIAFK_FAILED, this.plugin.getDefaultLanguage()), "{player}", user.getUsername(), "{check}", checkType.name(), "{count}", String.valueOf(checkData.getCount()));
        LogLocation logLocation = this.getLogLocation(ref);
        AntiAfkLog log = new AntiAfkLog(System.currentTimeMillis(), message, logLocation.coordinates(), logLocation.worldName());
        user.getSessionAntiAfkLogs().add(log);
        for (User notified : this.plugin.getUserManager().getOnlineUsers()) {
            if (!notified.hasPermission("auraskills.antiafk.notify")) continue;
            notified.sendMessage(message);
        }
    }

    public void registerChecks() {
        if (!this.plugin.configBoolean(Option.ANTI_AFK_ENABLED)) {
            return;
        }
        for (CheckType type : this.getCheckTypes()) {
            this.constructCheck(type).ifPresent(check -> {
                this.registerCheckEvents((Check)check);
                this.checkMap.put(type, (Check)check);
            });
        }
    }

    private Optional<Check> constructCheck(CheckType type) {
        Class<? extends Check> checkClass = type.getCheckClass();
        try {
            Constructor<?> constructor = this.getCheckConstructor(checkClass);
            Object checkObj = constructor.newInstance(type, this);
            if (checkObj instanceof Check) {
                Check check = (Check)checkObj;
                return Optional.of(check);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            this.plugin.logger().warn("Failed to register check of type " + String.valueOf(type));
            e.printStackTrace();
        }
        return Optional.empty();
    }

    private void loadLogThresholdExpression() {
        this.logThresholdExpression = new Expression(this.plugin.configString(Option.ANTI_AFK_LOG_THRESHOLD));
        try {
            this.logThresholdExpression.validate();
        }
        catch (ParseException e) {
            this.plugin.logger().warn("Failed to parse anti_afk.log_threshold expression: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

