/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.util.VersionUtils;
import dev.aurelium.auraskills.common.message.type.CommandMessage;
import dev.aurelium.auraskills.slate.util.TextUtil;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.VisibleForTesting;

public class UpdateChecker {
    public static final String MODRINTH_ID = "uDdZAVls";
    private final AuraSkills plugin;
    private final String projectId;

    public UpdateChecker(AuraSkills plugin) {
        this.plugin = plugin;
        this.projectId = MODRINTH_ID;
    }

    public void sendUpdateMessageAsync(CommandSender sender) {
        this.getVersion((versionOpt, idOpt) -> versionOpt.ifPresent(version -> idOpt.ifPresent(id -> {
            if (this.isOutdated(this.plugin.getDescription().getVersion(), (String)version)) {
                String prefix = sender instanceof Player ? this.plugin.getPrefix(this.plugin.getDefaultLanguage()) : "[AuraSkills] ";
                String downloadLink = "https://modrinth.com/plugin/uDdZAVls/version/" + id;
                String msg = dev.aurelium.auraskills.common.util.text.TextUtil.replace(this.plugin.getMsg(CommandMessage.VERSION_NEW_UPDATE, this.plugin.getLocale(sender)), "{current_version}", this.plugin.getDescription().getVersion(), "{latest_version}", version, "{link}", downloadLink, "{prefix}", prefix);
                if (!msg.isEmpty()) {
                    sender.sendMessage(msg);
                }
            }
        })));
    }

    public void getVersion(BiConsumer<Optional<String>, Optional<String>> consumer) {
        this.plugin.getScheduler().executeAsync(() -> {
            String serverName = Bukkit.getServer().getName();
            String loader = serverName.equalsIgnoreCase("CraftBukkit") || serverName.equalsIgnoreCase("Spigot") ? "spigot" : "paper";
            String baseUrl = "https://api.modrinth.com/v2/project/" + this.projectId + "/version";
            String gameVersion = VersionUtils.getVersionString(Bukkit.getBukkitVersion());
            String query = "loaders=%5B%22" + loader + "%22%5D&game_versions=%5B%22" + gameVersion + "%22%5D";
            String url = baseUrl + "?" + query;
            try (HttpClient client = HttpClient.newHttpClient();){
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).GET().build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() == 200) {
                    String responseBody = response.body();
                    if (responseBody == null || responseBody.trim().isEmpty()) {
                        this.acceptEmpty(consumer);
                        return;
                    }
                    JsonArray jsonArray = JsonParser.parseString((String)responseBody).getAsJsonArray();
                    if (jsonArray.isEmpty()) {
                        this.acceptEmpty(consumer);
                        return;
                    }
                    JsonObject firstRelease = null;
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        JsonObject versionObj = jsonArray.get(i).getAsJsonObject();
                        JsonElement element = versionObj.get("version_type");
                        if (element == null || !element.getAsString().equals("release")) continue;
                        firstRelease = versionObj;
                        break;
                    }
                    if (firstRelease == null) {
                        this.acceptEmpty(consumer);
                        return;
                    }
                    JsonElement versionNumElement = firstRelease.get("version_number");
                    if (versionNumElement == null) {
                        this.acceptEmpty(consumer);
                        return;
                    }
                    String versionNumber = versionNumElement.getAsString();
                    JsonElement idElement = firstRelease.get("id");
                    if (idElement == null) {
                        this.acceptEmpty(consumer);
                        return;
                    }
                    String id = idElement.getAsString();
                    consumer.accept(Optional.of(versionNumber), Optional.of(id));
                    return;
                }
                this.plugin.getLogger().info("Cannot look for updates: Request failed with status code " + response.statusCode());
            }
            catch (Exception e) {
                this.plugin.getLogger().info("Cannot look for updates: " + e.getMessage());
            }
            this.acceptEmpty(consumer);
        });
    }

    private void acceptEmpty(BiConsumer<Optional<String>, Optional<String>> consumer) {
        consumer.accept(Optional.empty(), Optional.empty());
    }

    @VisibleForTesting
    public boolean isOutdated(String localVersion, String resourceVersion) {
        if (localVersion.equalsIgnoreCase(resourceVersion)) {
            return false;
        }
        String[] localSplit = localVersion.split(" ");
        String[] resourceSplit = resourceVersion.split(" ");
        String localNum = localSplit.length >= 2 && resourceSplit.length >= 2 ? localSplit[1] : localSplit[0];
        String resourceNum = resourceSplit.length >= 2 ? resourceSplit[1] : resourceSplit[0];
        int localIndex = localNum.indexOf("-");
        int localSuffix = this.getSuffix(localNum);
        if (localIndex != -1) {
            localNum = localNum.substring(0, localIndex);
        }
        int resourceIndex = resourceNum.indexOf("-");
        int resourceSuffix = this.getSuffix(resourceNum);
        if (resourceIndex != -1) {
            resourceNum = resourceNum.substring(0, resourceIndex);
        }
        String[] localVersionSplit = localNum.split("\\.");
        String[] resourceVersionSplit = resourceNum.split("\\.");
        for (int i = 0; i < localVersionSplit.length && i < resourceVersionSplit.length; ++i) {
            try {
                int local = Integer.parseInt(localVersionSplit[i]);
                int resource = Integer.parseInt(resourceVersionSplit[i]);
                if (local < resource) {
                    return true;
                }
                if (local <= resource) continue;
                return false;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (localSuffix != -1 && resourceSuffix != -1) {
            return resourceSuffix > localSuffix;
        }
        return true;
    }

    private int getSuffix(String str) {
        int resourceIndex = str.indexOf("-");
        if (resourceIndex != -1) {
            String suffixStr = str.substring(resourceIndex + 1);
            if (suffixStr.contains("+")) {
                String[] arr = TextUtil.substringsBetween(suffixStr, ".", "+");
                if (arr != null && arr.length >= 1) {
                    try {
                        return Integer.parseInt(arr[0]);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else {
                String buildNumStr = suffixStr.substring(suffixStr.indexOf(".") + 1);
                try {
                    return Integer.parseInt(buildNumStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return -1;
    }
}

