/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.util;

import dev.aurelium.auraskills.bukkit.util.VersionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.jetbrains.annotations.Nullable;

public class SoundUtil {
    @Nullable
    private static Method soundValueOf = null;

    public static Sound getFromEitherName(String name) throws RuntimeException {
        Sound sound;
        String registryName = name.toLowerCase(Locale.ROOT);
        NamespacedKey key = NamespacedKey.fromString((String)registryName);
        if (key != null && (sound = (Sound)Registry.SOUNDS.get(key)) != null) {
            return sound;
        }
        if (VersionUtils.isAtLeastVersion(21, 3)) {
            return Sound.valueOf((String)name);
        }
        if (soundValueOf == null) {
            try {
                soundValueOf = Sound.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Object soundObj = soundValueOf.invoke(null, name.toUpperCase(Locale.ROOT));
            if (soundObj instanceof Sound) {
                Sound sound2 = (Sound)soundObj;
                return sound2;
            }
            throw new IllegalArgumentException("Returned object is not a Sound instance");
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

