/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.trait;

import dev.aurelium.auraskills.api.event.mana.ManaRegenerateEvent;
import dev.aurelium.auraskills.api.mana.ManaAbilities;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.Traits;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.trait.TraitImpl;
import dev.aurelium.auraskills.common.scheduler.TaskRunnable;
import dev.aurelium.auraskills.common.user.User;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ManaRegenTrait
extends TraitImpl {
    ManaRegenTrait(AuraSkills plugin) {
        super(plugin, Traits.MANA_REGEN);
        this.startRegen();
    }

    @Override
    public double getBaseLevel(Player player, Trait trait) {
        return Traits.MANA_REGEN.optionDouble("base");
    }

    @Override
    public String getMenuDisplay(double value, Trait trait, Locale locale) {
        return NumberUtil.format1(value) + "/s";
    }

    public void startRegen() {
        TaskRunnable task = new TaskRunnable(){

            @Override
            public void run() {
                if (!Traits.MANA_REGEN.isEnabled()) {
                    return;
                }
                for (Player player : Bukkit.getOnlinePlayers()) {
                    double maxMana;
                    User user = ManaRegenTrait.this.plugin.getUser(player);
                    double originalMana = user.getMana();
                    if (!(originalMana < (maxMana = user.getMaxMana())) || user.getAbilityData(ManaAbilities.ABSORPTION).getBoolean("activated")) continue;
                    double regen = user.getEffectiveTraitLevel(Traits.MANA_REGEN);
                    double finalRegen = Math.min(originalMana + regen, maxMana) - originalMana;
                    ManaRegenerateEvent event = new ManaRegenerateEvent(player, user.toApi(), finalRegen);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) continue;
                    user.setMana(originalMana + event.getAmount());
                }
            }
        };
        this.plugin.getScheduler().timerSync(task, 0L, 1L, TimeUnit.SECONDS);
    }
}

