/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.trait;

import dev.aurelium.auraskills.api.event.user.UserLoadEvent;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.Traits;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.trait.TraitImpl;
import dev.aurelium.auraskills.bukkit.util.AttributeCompat;
import dev.aurelium.auraskills.bukkit.util.VersionUtils;
import dev.aurelium.auraskills.common.user.User;
import java.util.UUID;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.plugin.Plugin;

public class LuckTrait
extends TraitImpl {
    private static final UUID LEGACY_MODIFIER_ID = UUID.fromString("fd1c6253-b865-454f-9203-002e3676a9da");
    private static final String MODIFIER_KEY = "luck_trait";

    LuckTrait(AuraSkills plugin) {
        super(plugin, Traits.LUCK);
    }

    @Override
    public double getBaseLevel(Player player, Trait trait) {
        AttributeInstance attribute = player.getAttribute(AttributeCompat.luck);
        if (attribute == null) {
            return 0.0;
        }
        double current = attribute.getValue();
        for (AttributeModifier am : attribute.getModifiers()) {
            if (!this.isLuckTraitModifier(am)) continue;
            current -= am.getAmount();
        }
        return current;
    }

    @EventHandler
    public void onJoin(UserLoadEvent event) {
        this.plugin.getScheduler().executeAtEntity((Entity)event.getPlayer(), task -> this.setLuck(event.getPlayer()));
    }

    @Override
    public void reload(Player player, Trait trait) {
        if (this.plugin.getScheduler().isFolia()) {
            this.plugin.getScheduler().executeAtEntity((Entity)player, task -> this.setLuck(player));
        } else {
            this.setLuck(player);
        }
    }

    @Override
    public void changeWorld(PlayerChangedWorldEvent event, Trait trait) {
        if (!trait.equals(Traits.LUCK)) {
            return;
        }
        this.setLuck(event.getPlayer());
    }

    private void setLuck(Player player) {
        AttributeInstance attribute = player.getAttribute(AttributeCompat.luck);
        if (attribute == null) {
            return;
        }
        boolean hasModifier = false;
        for (AttributeModifier am : attribute.getModifiers()) {
            if (!this.isLuckTraitModifier(am)) continue;
            attribute.removeModifier(am);
            hasModifier = true;
        }
        if (!Traits.LUCK.isEnabled()) {
            return;
        }
        if (!hasModifier) {
            attribute.setBaseValue(0.0);
        }
        if (this.plugin.getWorldManager().isInDisabledWorld(player.getLocation())) {
            return;
        }
        User user = this.plugin.getUser(player);
        double luck = user.getBonusTraitLevel(Traits.LUCK);
        if (luck < 0.01) {
            return;
        }
        if (VersionUtils.isAtLeastVersion(21)) {
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, MODIFIER_KEY);
            attribute.addModifier(new AttributeModifier(key, luck, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.ANY));
        } else {
            attribute.addModifier(new AttributeModifier(LEGACY_MODIFIER_ID, "AureliumSkills-Luck", luck, AttributeModifier.Operation.ADD_NUMBER));
        }
    }

    private boolean isLuckTraitModifier(AttributeModifier modifier) {
        String legacyModifierName = "AureliumSkills-Luck";
        if (modifier.getName().equals("AureliumSkills-Luck")) {
            return true;
        }
        if (VersionUtils.isAtLeastVersion(21)) {
            String attributeNamespace = "auraskills";
            String namespace = modifier.getKey().getNamespace();
            String key = modifier.getKey().getKey();
            if (key.equals(LEGACY_MODIFIER_ID.toString())) {
                return true;
            }
            if (namespace.equals("auraskills") && key.equals(MODIFIER_KEY)) {
                return true;
            }
            try {
                UUID.fromString(key);
                if (namespace.equals("minecraft") && modifier.getAmount() == 0.0 && modifier.getOperation().equals((Object)AttributeModifier.Operation.ADD_NUMBER)) {
                    return true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }
}

