/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.source;

import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.skill.Skills;
import dev.aurelium.auraskills.api.source.SkillSource;
import dev.aurelium.auraskills.api.source.type.DamageXpSource;
import dev.aurelium.auraskills.api.source.type.EntityXpSource;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.hooks.mythicmobs.MythicMobsHook;
import dev.aurelium.auraskills.bukkit.source.SourceLeveler;
import dev.aurelium.auraskills.bukkit.util.AttributeCompat;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.source.SourceTypes;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.data.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.Nullable;

public class EntityLeveler
extends SourceLeveler {
    private final NamespacedKey spawnerMobKey;
    private final NamespacedKey roseStackerSpawner;

    public EntityLeveler(AuraSkills plugin) {
        super(plugin, SourceTypes.ENTITY);
        this.spawnerMobKey = new NamespacedKey((Plugin)plugin, "is_spawner_mob");
        this.roseStackerSpawner = NamespacedKey.fromString((String)"rosestacker:spawner_spawned");
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDeath(EntityDeathEvent event) {
        EntityXpSource.EntityDamagers damager;
        EntityDamageEvent.DamageCause damageCause;
        Entity damagerEntity;
        if (this.disabled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (this.preventMythicXp(entity)) {
            return;
        }
        @Nullable Player player = entity.getKiller();
        EntityDamageEvent entityDamageEvent = entity.getLastDamageCause();
        if (entityDamageEvent instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent damageEvent = (EntityDamageByEntityEvent)entityDamageEvent;
            damagerEntity = damageEvent.getDamager();
            damageCause = damageEvent.getCause();
        } else {
            player = this.getBleedDamager((Entity)entity);
            damagerEntity = player;
            damageCause = EntityDamageEvent.DamageCause.CUSTOM;
        }
        if (player == null) {
            return;
        }
        User user = this.plugin.getUser(player);
        if (damagerEntity instanceof Player) {
            damager = EntityXpSource.EntityDamagers.PLAYER;
        } else if (damagerEntity instanceof Projectile) {
            damager = EntityXpSource.EntityDamagers.PROJECTILE;
        } else {
            return;
        }
        SkillSource<EntityXpSource> skillSource = this.getSource(entity, damager, EntityXpSource.EntityTriggers.DEATH, damageCause);
        if (skillSource == null) {
            return;
        }
        EntityXpSource source = skillSource.source();
        Skill skill = skillSource.skill();
        if (this.failsChecks(player, entity.getLocation(), skill)) {
            return;
        }
        this.plugin.getLevelManager().addEntityXp(user, skill, source, this.getSpawnerMultiplier((Entity)entity, skill) * source.getXp(), entity, damagerEntity, (EntityEvent)event);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        LivingEntity entity;
        block10: {
            block9: {
                if (this.disabled()) {
                    return;
                }
                Entity entity2 = event.getEntity();
                if (!(entity2 instanceof LivingEntity)) break block9;
                entity = (LivingEntity)entity2;
                if (!(event.getEntity() instanceof ArmorStand)) break block10;
            }
            return;
        }
        if (this.preventMythicXp(entity)) {
            return;
        }
        Pair<Player, EntityXpSource.EntityDamagers> damagerPair = this.resolveDamager(event.getDamager(), event.getCause());
        if (damagerPair == null) {
            return;
        }
        Player player = damagerPair.first();
        if (player.hasMetadata("NPC")) {
            return;
        }
        User user = this.plugin.getUser(player);
        EntityXpSource.EntityDamagers damager = damagerPair.second();
        SkillSource<EntityXpSource> skillSource = this.getSource(entity, damager, EntityXpSource.EntityTriggers.DAMAGE, event.getCause());
        if (skillSource == null) {
            return;
        }
        EntityXpSource source = skillSource.source();
        Skill skill = skillSource.skill();
        if (this.failsChecks((Cancellable)event, player, entity.getLocation(), skill)) {
            return;
        }
        double damageMultiplier = this.getDamageMultiplier(entity, source, (EntityDamageEvent)event);
        this.plugin.getLevelManager().addEntityXp(user, skill, source, damageMultiplier * this.getSpawnerMultiplier((Entity)entity, skill) * source.getXp(), entity, event.getDamager(), (EntityEvent)event);
    }

    @EventHandler
    public void onBleedDamage(EntityDamageEvent event) {
        LivingEntity entity;
        block10: {
            block9: {
                if (this.disabled()) {
                    return;
                }
                Entity entity2 = event.getEntity();
                if (!(entity2 instanceof LivingEntity)) break block9;
                entity = (LivingEntity)entity2;
                if (!(event.getEntity() instanceof ArmorStand)) break block10;
            }
            return;
        }
        if (this.preventMythicXp(entity)) {
            return;
        }
        Player player = this.getBleedDamager((Entity)entity);
        if (player == null) {
            return;
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        User user = this.plugin.getUser(player);
        SkillSource<EntityXpSource> skillSource = this.getSource(entity, EntityXpSource.EntityDamagers.PLAYER, EntityXpSource.EntityTriggers.DAMAGE, EntityDamageEvent.DamageCause.CUSTOM);
        if (skillSource == null) {
            return;
        }
        EntityXpSource source = skillSource.source();
        Skill skill = skillSource.skill();
        if (this.failsChecks(player, entity.getLocation(), skill)) {
            return;
        }
        double damageMultiplier = this.getDamageMultiplier(entity, source, event);
        this.plugin.getLevelManager().addEntityXp(user, skill, source, damageMultiplier * this.getSpawnerMultiplier((Entity)entity, skill) * source.getXp(), entity, (Entity)player, null);
    }

    @Nullable
    public Pair<Player, EntityXpSource.EntityDamagers> resolveDamager(Entity damager, EntityDamageEvent.DamageCause cause) {
        if (damager instanceof Player) {
            Player player = (Player)damager;
            if (cause != EntityDamageEvent.DamageCause.ENTITY_ATTACK && cause != EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK) {
                return null;
            }
            return new Pair<Player, EntityXpSource.EntityDamagers>(player, EntityXpSource.EntityDamagers.PLAYER);
        }
        if (damager instanceof Projectile) {
            Projectile projectile = (Projectile)damager;
            ProjectileSource projectileSource = projectile.getShooter();
            if (!(projectileSource instanceof Player)) {
                return null;
            }
            Player player = (Player)projectileSource;
            if (damager instanceof ThrownPotion && Skills.ALCHEMY.isEnabled() && this.plugin.configBoolean(Option.SOURCE_ENTITY_GIVE_ALCHEMY_ON_POTION_COMBAT)) {
                return new Pair<Player, EntityXpSource.EntityDamagers>(player, EntityXpSource.EntityDamagers.THROWN_POTION);
            }
            return new Pair<Player, EntityXpSource.EntityDamagers>(player, EntityXpSource.EntityDamagers.PROJECTILE);
        }
        return null;
    }

    /*
     * Could not resolve type clashes
     */
    @Nullable
    public SkillSource<EntityXpSource> getSource(LivingEntity entity, EntityXpSource.EntityDamagers eventDamager, EntityXpSource.EntityTriggers trigger, EntityDamageEvent.DamageCause damageCause) {
        List<SkillSource<EntityXpSource>> sources = this.plugin.getSkillManager().getSourcesOfType(EntityXpSource.class);
        sources = this.filterByTrigger(sources, trigger);
        for (SkillSource<EntityXpSource> entry : sources) {
            DamageXpSource.DamageCause[] excludedCauses;
            EntityXpSource source = entry.source();
            String entityName = this.plugin.getPlatformUtil().convertEntityName(source.getEntity().toLowerCase(Locale.ROOT));
            if (!entityName.toUpperCase(Locale.ROOT).equals(entity.getType().toString())) continue;
            DamageXpSource.DamageCause[] causes = source.getCauses();
            if (causes != null) {
                boolean matchingCause = false;
                for (Enum cause : causes) {
                    if (!cause.toString().equals(damageCause.toString())) continue;
                    matchingCause = true;
                    break;
                }
                if (!matchingCause) continue;
            }
            if ((excludedCauses = source.getExcludedCauses()) != null) {
                boolean matchingCause = false;
                DamageXpSource.DamageCause[] damageCauseArray = excludedCauses;
                int n = damageCauseArray.length;
                for (int cause = 0; cause < n; ++cause) {
                    DamageXpSource.DamageCause cause2 = damageCauseArray[cause];
                    if (!cause2.toString().equals(damageCause.toString())) continue;
                    matchingCause = true;
                    break;
                }
                if (matchingCause) continue;
            }
            if (eventDamager == EntityXpSource.EntityDamagers.THROWN_POTION) {
                return new SkillSource<EntityXpSource>(source, Skills.ALCHEMY);
            }
            for (Enum sourceDamager : source.getDamagers()) {
                if (sourceDamager != eventDamager) continue;
                return entry;
            }
        }
        return null;
    }

    private boolean preventMythicXp(LivingEntity entity) {
        if (this.plugin.getHookManager().isRegistered(MythicMobsHook.class)) {
            return this.plugin.getHookManager().getHook(MythicMobsHook.class).shouldPreventEntityXp((Entity)entity);
        }
        return false;
    }

    private List<SkillSource<EntityXpSource>> filterByTrigger(List<SkillSource<EntityXpSource>> sources, EntityXpSource.EntityTriggers trigger) {
        ArrayList<SkillSource<EntityXpSource>> filtered = new ArrayList<SkillSource<EntityXpSource>>();
        block0: for (SkillSource<EntityXpSource> entry : sources) {
            EntityXpSource source = entry.source();
            for (EntityXpSource.EntityTriggers sourceTrigger : source.getTriggers()) {
                if (sourceTrigger != trigger) continue;
                filtered.add(entry);
                continue block0;
            }
        }
        return filtered;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onMobSpawn(CreatureSpawnEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getSpawnReason() != CreatureSpawnEvent.SpawnReason.SPAWNER) {
            return;
        }
        if (!Skills.FIGHTING.isEnabled() && !Skills.ARCHERY.isEnabled()) {
            return;
        }
        if (Skills.FIGHTING.optionDouble("spawner_multiplier", 1.0) == 1.0 && Skills.ARCHERY.optionDouble("spawner_multiplier", 1.0) == 1.0) {
            return;
        }
        LivingEntity entity = event.getEntity();
        PersistentDataContainer data = entity.getPersistentDataContainer();
        data.set(this.spawnerMobKey, PersistentDataType.INTEGER, (Object)1);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onMobTransform(EntityTransformEvent event) {
        if (event.getTransformReason() != EntityTransformEvent.TransformReason.SPLIT && event.getTransformReason() != EntityTransformEvent.TransformReason.DROWNED) {
            return;
        }
        Entity original = event.getEntity();
        if (!original.getPersistentDataContainer().has(this.spawnerMobKey, PersistentDataType.INTEGER)) {
            return;
        }
        for (Entity entity : event.getTransformedEntities()) {
            entity.getPersistentDataContainer().set(this.spawnerMobKey, PersistentDataType.INTEGER, (Object)1);
        }
    }

    private double getSpawnerMultiplier(Entity entity, Skill skill) {
        if (this.isSpawnerSpawned(entity)) {
            return skill.optionDouble("spawner_multiplier", 1.0);
        }
        return 1.0;
    }

    private boolean isSpawnerSpawned(Entity entity) {
        PersistentDataContainer container = entity.getPersistentDataContainer();
        if (container.has(this.spawnerMobKey, PersistentDataType.INTEGER)) {
            return true;
        }
        return container.has(this.roseStackerSpawner, PersistentDataType.INTEGER);
    }

    @Nullable
    private Player getBleedDamager(Entity entity) {
        NamespacedKey key;
        PersistentDataContainer container = entity.getPersistentDataContainer();
        if (container.has(key = new NamespacedKey((Plugin)this.plugin, "bleed_damager"), PersistentDataType.STRING)) {
            String uuidStr = (String)container.get(key, PersistentDataType.STRING);
            if (uuidStr == null) {
                return null;
            }
            UUID uuid = UUID.fromString(uuidStr);
            return Bukkit.getPlayer((UUID)uuid);
        }
        return null;
    }

    private double getDamageMultiplier(LivingEntity entity, EntityXpSource source, EntityDamageEvent event) {
        AttributeInstance healthAttribute;
        double damageDealt = Math.min(entity.getHealth(), event.getFinalDamage());
        if (source.scaleXpWithHealth() && (healthAttribute = entity.getAttribute(AttributeCompat.maxHealth)) != null) {
            double maxHealth = healthAttribute.getValue();
            return damageDealt / maxHealth;
        }
        return damageDealt;
    }
}

