/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.source;

import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.source.SkillSource;
import dev.aurelium.auraskills.api.source.XpSource;
import dev.aurelium.auraskills.api.source.type.BlockXpSource;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.skills.mining.MiningAbilities;
import dev.aurelium.auraskills.bukkit.source.BlockLevelerHelper;
import dev.aurelium.auraskills.bukkit.source.SourceLeveler;
import dev.aurelium.auraskills.bukkit.trait.GatheringLuckTraits;
import dev.aurelium.auraskills.common.source.SourceTypes;
import dev.aurelium.auraskills.common.user.User;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.type.Beehive;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class BlockLeveler
extends SourceLeveler {
    private final BlockLevelerHelper helper;
    private final Map<UniqueBlock, SkillSource<BlockXpSource>> sourceCache;
    private final Set<Material> collectShearBlocks = Set.of(Material.BEEHIVE, Material.BEE_NEST);
    private final Set<Material> collectBottleBlocks = Set.of(Material.BEEHIVE, Material.BEE_NEST, Material.CAULDRON, Material.WATER_CAULDRON);
    private final Set<Material> collectBucketBlocks = Set.of(Material.CAULDRON, Material.WATER_CAULDRON, Material.LAVA_CAULDRON, Material.POWDER_SNOW_CAULDRON);

    public BlockLeveler(AuraSkills plugin) {
        super(plugin, SourceTypes.BLOCK);
        this.helper = new BlockLevelerHelper(plugin);
        this.sourceCache = new ConcurrentHashMap<UniqueBlock, SkillSource<BlockXpSource>>();
    }

    public void clearSourceCache() {
        this.sourceCache.clear();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBreak(BlockBreakEvent event) {
        if (this.disabled()) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlock();
        this.handleBreak(player, block, (Cancellable)event, trait -> event.isDropItems() ? trait.getUniqueDrops(block, player) : Collections.emptySet());
    }

    public void handleBreak(Player player, Block block, Cancellable event, Function<GatheringLuckTraits, Set<ItemStack>> dropFunction) {
        User user = this.plugin.getUser(player);
        SkillSource<BlockXpSource> skillSource = this.getSource(block, BlockXpSource.BlockTriggers.BREAK);
        if (skillSource == null) {
            return;
        }
        BlockXpSource source = skillSource.source();
        Skill skill = skillSource.skill();
        if (this.failsChecks(event, player, block.getLocation(), skill)) {
            return;
        }
        if (source.checkReplace() && this.plugin.getRegionManager().isPlacedBlock(block)) {
            MiningAbilities miningAbilities = this.plugin.getAbilityManager().getAbilityImpl(MiningAbilities.class);
            if (miningAbilities.dropsMineralDirectly(block)) {
                this.applyBlockLuck(skill, player, user, block, source, dropFunction);
            }
            return;
        }
        double multiplier = this.helper.getBlocksBroken(block, source);
        this.plugin.getLevelManager().addXp(user, skill, source, source.getXp() * (multiplier *= this.helper.getStateMultiplier(block, source)));
        this.applyBlockLuck(skill, player, user, block, source, dropFunction);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventHandler(priority=EventPriority.MONITOR)
    public void onInteract(PlayerInteractEvent event) {
        if (this.disabled()) {
            return;
        }
        Player player = event.getPlayer();
        User user = this.plugin.getUser(player);
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        if (this.hasSkippableMeta(block, event)) {
            return;
        }
        boolean collecting = false;
        SkillSource<BlockXpSource> skillSource = this.getSource(block, BlockXpSource.BlockTriggers.INTERACT);
        if (skillSource == null) {
            skillSource = this.getSource(block, BlockXpSource.BlockTriggers.COLLECT);
            collecting = true;
            if (skillSource == null) {
                return;
            }
        }
        if (collecting) {
            boolean collectWithBuckets;
            ItemStack item = event.getItem();
            if (item == null) {
                return;
            }
            Material itemType = item.getType();
            Material blockType = block.getType();
            boolean collectWithShears = itemType == Material.SHEARS && this.collectShearBlocks.contains(blockType);
            boolean collectWithBottles = itemType == Material.GLASS_BOTTLE && this.collectBottleBlocks.contains(blockType);
            boolean bl = collectWithBuckets = itemType == Material.BUCKET && this.collectBucketBlocks.contains(blockType);
            if (!collectWithShears && !collectWithBottles && !collectWithBuckets) return;
            BlockData blockData = block.getBlockData();
            if (blockData instanceof Beehive) {
                Beehive beehive = (Beehive)blockData;
                if (beehive.getHoneyLevel() < beehive.getMaximumHoneyLevel()) {
                    return;
                }
            } else {
                if (!(blockData instanceof Levelled)) return;
                Levelled levelled = (Levelled)blockData;
                if (levelled.getLevel() == 0 && itemType == Material.GLASS_BOTTLE) {
                    return;
                }
                if (levelled.getLevel() < levelled.getMaximumLevel() && itemType == Material.BUCKET) {
                    return;
                }
            }
        }
        BlockXpSource source = skillSource.source();
        Skill skill = skillSource.skill();
        if (this.failsChecks((Cancellable)event, player, block.getLocation(), skill)) {
            return;
        }
        double multiplier = (double)this.helper.getBlocksBroken(block, source) * this.helper.getStateMultiplier(block, source);
        Material materialBefore = block.getType();
        if (source.getAfterStates() != null) {
            this.plugin.getScheduler().scheduleAtLocation(block.getLocation(), () -> {
                if (materialBefore == block.getType() && this.matchesStates(block, source.getAfterStates())) {
                    this.plugin.getLevelManager().addXp(user, skill, source, source.getXp() * multiplier);
                    this.applyBlockLuck(skill, player, user, block, source);
                }
            }, 50L, TimeUnit.MILLISECONDS);
            return;
        } else {
            this.plugin.getLevelManager().addXp(user, skill, source, source.getXp() * multiplier);
            this.applyBlockLuck(skill, player, user, block, source);
        }
    }

    private boolean hasSkippableMeta(Block block, PlayerInteractEvent event) {
        ItemStack item = event.getItem();
        Material itemType = item != null ? item.getType() : Material.AIR;
        boolean emptyLeveler = false;
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Levelled) {
            Levelled levelled = (Levelled)blockData;
            if (itemType == Material.BUCKET && levelled.getLevel() == 3 || itemType == Material.GLASS_BOTTLE && levelled.getLevel() == 1) {
                emptyLeveler = true;
            }
        }
        if (this.isFertilized(block)) {
            return true;
        }
        for (String metaKey : List.of("filledManually")) {
            MetadataValue metaDataValue;
            List metaDataList = block.getMetadata(metaKey);
            if (metaDataList.isEmpty() || !(metaDataValue = (MetadataValue)metaDataList.getFirst()).asBoolean()) continue;
            if (emptyLeveler) {
                block.removeMetadata(metaKey, (Plugin)this.plugin);
            }
            return true;
        }
        return false;
    }

    private boolean isFertilized(Block block) {
        MetadataValue metaDataValue;
        String key = "fertilized";
        List metaDataList = block.getMetadata(key);
        if (!metaDataList.isEmpty() && (metaDataValue = (MetadataValue)metaDataList.getFirst()).asBoolean()) {
            block.removeMetadata(key, (Plugin)this.plugin);
            return true;
        }
        return false;
    }

    private void applyBlockLuck(Skill skill, Player player, User user, Block block, XpSource source) {
        this.applyBlockLuck(skill, player, user, block, source, trait -> trait.getUniqueDrops(block, player));
    }

    private void applyBlockLuck(Skill skill, Player player, User user, Block block, XpSource source, Function<GatheringLuckTraits, Set<ItemStack>> dropFunction) {
        ItemStack tool = player.getInventory().getItemInMainHand();
        if (tool.getEnchantmentLevel(Enchantment.SILK_TOUCH) > 0 && this.plugin.getAbilityManager().getAbilityImpl(MiningAbilities.class).dropsMineralDirectly(block)) {
            return;
        }
        GatheringLuckTraits traitImpl = this.plugin.getTraitManager().getTraitImpl(GatheringLuckTraits.class);
        Trait blockLuckTrait = traitImpl.getTrait(skill);
        if (blockLuckTrait != null) {
            traitImpl.apply(blockLuckTrait, block, player, user, source, dropFunction.apply(traitImpl));
        }
    }

    public boolean isDifferentSource(Block block, BlockXpSource source, BlockXpSource.BlockTriggers trigger) {
        SkillSource<BlockXpSource> skillSource = this.getSource(block, trigger);
        if (skillSource == null) {
            return true;
        }
        return !skillSource.source().equals(source);
    }

    @Nullable
    public SkillSource<BlockXpSource> getSource(Block block, BlockXpSource.BlockTriggers trigger) {
        if (block.getType().isAir()) {
            return null;
        }
        UniqueBlock cacheKey = new UniqueBlock(block.getType(), block.getBlockData().getAsString(true), trigger);
        SkillSource<BlockXpSource> cachedSource = this.sourceCache.get(cacheKey);
        if (cachedSource != null) {
            return cachedSource;
        }
        List<SkillSource<BlockXpSource>> sources = this.plugin.getSkillManager().getSourcesOfType(BlockXpSource.class);
        sources = this.filterByTrigger(sources, trigger);
        for (SkillSource<BlockXpSource> entry : sources) {
            BlockXpSource source = entry.source();
            if (!this.matchesMaterial(source, block) || source.getStates() != null && !this.matchesStates(block, source.getStates())) continue;
            this.sourceCache.put(cacheKey, entry);
            return entry;
        }
        return null;
    }

    public SkillSource<BlockXpSource> getSourceByMaterialOnly(Block block) {
        List<SkillSource<BlockXpSource>> sources = this.plugin.getSkillManager().getSourcesOfType(BlockXpSource.class);
        for (SkillSource<BlockXpSource> entry : sources) {
            BlockXpSource source = entry.source();
            if (!this.matchesMaterial(source, block)) continue;
            return entry;
        }
        return null;
    }

    private boolean matchesMaterial(BlockXpSource candidate, Block block) {
        boolean blockMatches = false;
        for (String blockName : candidate.getBlocks()) {
            if (!block.getType().name().equalsIgnoreCase(blockName)) continue;
            blockMatches = true;
            break;
        }
        return blockMatches;
    }

    private boolean matchesStates(Block block, BlockXpSource.BlockXpSourceState[] states) {
        String blockDataString = block.getBlockData().getAsString(true);
        Map<String, Object> blockDataMap = BlockLeveler.parseFromBlockData(blockDataString);
        for (BlockXpSource.BlockXpSourceState state : states) {
            if (state == null) continue;
            boolean stateMatches = true;
            for (Map.Entry<String, Object> stateEntry : state.getStateMap().entrySet()) {
                String key = stateEntry.getKey();
                Object value = stateEntry.getValue();
                if (!blockDataMap.containsKey(key)) {
                    stateMatches = false;
                    break;
                }
                if (blockDataMap.get(key).equals(value)) continue;
                stateMatches = false;
                break;
            }
            if (!stateMatches) continue;
            return true;
        }
        return false;
    }

    private List<SkillSource<BlockXpSource>> filterByTrigger(List<SkillSource<BlockXpSource>> sources, BlockXpSource.BlockTriggers trigger) {
        ArrayList<SkillSource<BlockXpSource>> filtered = new ArrayList<SkillSource<BlockXpSource>>();
        block0: for (SkillSource<BlockXpSource> entry : sources) {
            BlockXpSource source = entry.source();
            for (BlockXpSource.BlockTriggers sourceTrigger : source.getTriggers()) {
                if (sourceTrigger != trigger) continue;
                filtered.add(entry);
                continue block0;
            }
        }
        return filtered;
    }

    public static Map<String, Object> parseFromBlockData(String input) {
        int equalIndex;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (input == null || input.isEmpty()) {
            return result;
        }
        int bracketIndex = input.indexOf("[");
        if (bracketIndex == -1) {
            return result;
        }
        String data = input.substring(bracketIndex + 1).replace("]", "");
        int commaIndex = data.indexOf(",");
        while (commaIndex != -1) {
            String pair = data.substring(0, commaIndex);
            int equalIndex2 = pair.indexOf("=");
            if (equalIndex2 != -1) {
                String key = pair.substring(0, equalIndex2).trim();
                String value = pair.substring(equalIndex2 + 1).trim();
                result.put(key, BlockLeveler.parseValue(value));
            }
            data = data.substring(commaIndex + 1);
            commaIndex = data.indexOf(",");
        }
        if (!data.isEmpty() && (equalIndex = data.indexOf("=")) != -1) {
            String key = data.substring(0, equalIndex).trim();
            String value = data.substring(equalIndex + 1).trim();
            result.put(key, BlockLeveler.parseValue(value));
        }
        return result;
    }

    private static Object parseValue(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException2) {
                if (value.equals("true")) {
                    return true;
                }
                if (value.equals("false")) {
                    return false;
                }
                return value;
            }
        }
    }

    public record UniqueBlock(Material material, String blockData, BlockXpSource.BlockTriggers trigger) {
    }
}

