/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.skills.healing;

import dev.aurelium.auraskills.api.ability.Abilities;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.api.stat.Stats;
import dev.aurelium.auraskills.api.util.AuraSkillsModifier;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.ability.BukkitAbilityImpl;
import dev.aurelium.auraskills.common.message.type.AbilityMessage;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;

public class HealingAbilities
extends BukkitAbilityImpl {
    private static final String REVIVAL_HEALTH_MODIFIER_NAME = "AureliumSkills.Ability.Revival.Health";
    private static final String REVIVAL_REGEN_MODIFIER_NAME = "AureliumSkills.Ability.Revival.Regeneration";

    public HealingAbilities(AuraSkills plugin) {
        super(plugin, Abilities.LIFE_ESSENCE, Abilities.HEALER, Abilities.LIFE_STEAL, Abilities.GOLDEN_HEART, Abilities.REVIVAL);
    }

    @EventHandler
    public void lifeEssence(EntityRegainHealthEvent event) {
        Abilities ability = Abilities.LIFE_ESSENCE;
        if (this.isDisabled(ability)) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.failsChecks(player, ability)) {
            return;
        }
        if (event.getRegainReason() != EntityRegainHealthEvent.RegainReason.MAGIC) {
            return;
        }
        User user = this.plugin.getUser(player);
        double multiplier = 1.0 + this.getValue(ability, user) / 100.0;
        event.setAmount(event.getAmount() * multiplier);
    }

    @EventHandler
    public void revival(PlayerRespawnEvent event) {
        Abilities ability = Abilities.REVIVAL;
        if (this.isDisabled(ability)) {
            return;
        }
        Player player = event.getPlayer();
        if (this.failsChecks(player, ability)) {
            return;
        }
        User user = this.plugin.getUser(player);
        double healthBonus = this.getValue(ability, user);
        double regenerationBonus = this.getSecondaryValue(ability, user);
        StatModifier healthModifier = new StatModifier(REVIVAL_HEALTH_MODIFIER_NAME, Stats.HEALTH, healthBonus, AuraSkillsModifier.Operation.ADD);
        StatModifier regenerationModifier = new StatModifier(REVIVAL_REGEN_MODIFIER_NAME, Stats.REGENERATION, regenerationBonus, AuraSkillsModifier.Operation.ADD);
        user.addStatModifier(healthModifier);
        user.addStatModifier(regenerationModifier);
        if (ability.optionBoolean("enable_message", true)) {
            Locale locale = user.getLocale();
            this.plugin.getAbilityManager().sendMessage(player, TextUtil.replace(this.plugin.getMsg(AbilityMessage.REVIVAL_MESSAGE, locale), "{value}", NumberUtil.format1(healthBonus), "{value_2}", NumberUtil.format1(regenerationBonus)));
        }
        this.plugin.getScheduler().scheduleAtEntity((Entity)player, () -> {
            user.removeStatModifier(REVIVAL_HEALTH_MODIFIER_NAME);
            user.removeStatModifier(REVIVAL_REGEN_MODIFIER_NAME);
        }, 30L, TimeUnit.SECONDS);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void revivalLeave(PlayerQuitEvent event) {
        User user = this.plugin.getUser(event.getPlayer());
        user.removeStatModifier(REVIVAL_HEALTH_MODIFIER_NAME);
        user.removeStatModifier(REVIVAL_REGEN_MODIFIER_NAME);
    }
}

