/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.skills.defense;

import dev.aurelium.auraskills.api.ability.Abilities;
import dev.aurelium.auraskills.api.damage.DamageMeta;
import dev.aurelium.auraskills.api.damage.DamageModifier;
import dev.aurelium.auraskills.api.event.damage.DamageEvent;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.ability.BukkitAbilityImpl;
import dev.aurelium.auraskills.bukkit.util.CompatUtil;
import dev.aurelium.auraskills.bukkit.util.VersionUtils;
import dev.aurelium.auraskills.common.user.User;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionEffectTypeCategory;

public class DefenseAbilities
extends BukkitAbilityImpl {
    public DefenseAbilities(AuraSkills plugin) {
        super(plugin, Abilities.SHIELDING, Abilities.DEFENDER, Abilities.MOB_MASTER, Abilities.IMMUNITY, Abilities.NO_DEBUFF);
    }

    public DamageModifier shielding(User user, Player player) {
        Abilities ability = Abilities.SHIELDING;
        if (this.isDisabled(ability)) {
            return DamageModifier.none();
        }
        if (this.failsChecks(player, ability)) {
            return DamageModifier.none();
        }
        if (!player.isSneaking()) {
            return DamageModifier.none();
        }
        if (user.getAbilityLevel(ability) <= 0) {
            return DamageModifier.none();
        }
        double damageReduction = 1.0 - this.getValue(ability, user) / 100.0;
        return new DamageModifier(damageReduction - 1.0, DamageModifier.Operation.MULTIPLY);
    }

    public DamageModifier mobMaster(DamageMeta meta, User user, Player player) {
        Abilities ability = Abilities.MOB_MASTER;
        if (this.isDisabled(ability)) {
            return DamageModifier.none();
        }
        if (this.failsChecks(player, ability)) {
            return DamageModifier.none();
        }
        if (meta.getAttacker() instanceof LivingEntity && !(meta.getAttacker() instanceof Player)) {
            if (user.getAbilityLevel(ability) <= 0) {
                return DamageModifier.none();
            }
            double damageReduction = 1.0 - this.getValue(ability, user) / 100.0;
            return new DamageModifier(damageReduction - 1.0, DamageModifier.Operation.MULTIPLY);
        }
        return DamageModifier.none();
    }

    public void immunity(EntityDamageByEntityEvent event, User user, Player player) {
        Abilities ability = Abilities.IMMUNITY;
        if (this.isDisabled(ability)) {
            return;
        }
        if (this.failsChecks(player, ability)) {
            return;
        }
        double chance = this.getValue(ability, user) / 100.0;
        if (this.rand.nextDouble() < chance) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void noDebuff(PotionSplashEvent event) {
        Abilities ability = Abilities.NO_DEBUFF;
        if (this.isDisabled(ability)) {
            return;
        }
        for (LivingEntity entity : event.getAffectedEntities()) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            if (this.failsChecks(player, ability)) {
                return;
            }
            for (PotionEffect effect : event.getPotion().getEffects()) {
                PotionEffectType type = effect.getType();
                if (!this.isNegativeEffect(type)) continue;
                User user = this.plugin.getUser(player);
                double chance = this.getValue(ability, user) / 100.0;
                if (!(this.rand.nextDouble() < chance) || player.hasPotionEffect(type)) continue;
                event.setIntensity(entity, 0.0);
            }
        }
    }

    private boolean isNegativeEffect(PotionEffectType type) {
        if (VersionUtils.isAtLeastVersion(20, 6)) {
            return type.getCategory() == PotionEffectTypeCategory.HARMFUL;
        }
        return type.equals(PotionEffectType.POISON) || type.equals(PotionEffectType.UNLUCK) || type.equals(PotionEffectType.WITHER) || type.equals(PotionEffectType.WEAKNESS) || type.equals(PotionEffectType.HUNGER) || type.equals(PotionEffectType.BLINDNESS) || CompatUtil.isEffect(type, Set.of("slowness", "slow")) || CompatUtil.isEffect(type, Set.of("mining_fatigue", "slow_digging")) || CompatUtil.isEffect(type, Set.of("instant_damage", "harm")) || CompatUtil.isEffect(type, Set.of("nausea", "confusion"));
    }

    public void noDebuffFire(User user, Player player, LivingEntity entity) {
        Abilities ability = Abilities.NO_DEBUFF;
        if (this.isDisabled(ability)) {
            return;
        }
        if (this.failsChecks(player, ability)) {
            return;
        }
        if (entity.getEquipment() == null) {
            return;
        }
        ItemStack item = entity.getEquipment().getItemInMainHand();
        if (item.getEnchantmentLevel(Enchantment.FIRE_ASPECT) > 0) {
            double chance = this.getValue(ability, user) / 100.0;
            if (this.rand.nextDouble() < chance) {
                this.plugin.getScheduler().scheduleAtEntity((Entity)player, () -> player.setFireTicks(0), 50L, TimeUnit.MILLISECONDS);
            }
        }
    }

    @EventHandler
    public void defenseListener(EntityDamageByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.hasMetadata("NPC")) {
            return;
        }
        User user = this.plugin.getUser(player);
        Entity entity2 = event.getDamager();
        if (entity2 instanceof LivingEntity) {
            LivingEntity entity3 = (LivingEntity)entity2;
            this.noDebuffFire(user, player, entity3);
        }
        this.immunity(event, user, player);
    }

    @EventHandler(ignoreCancelled=true)
    public void damageListener(DamageEvent event) {
        DamageMeta meta = event.getDamageMeta();
        Player target = meta.getTargetAsPlayer();
        if (target != null) {
            User user = this.plugin.getUser(target);
            meta.addDefenseModifier(this.mobMaster(meta, user, target));
            meta.addDefenseModifier(this.shielding(user, target));
        }
    }
}

