/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.message;

import dev.aurelium.auraskills.acf.MessageKeys;
import dev.aurelium.auraskills.acf.MinecraftMessageKeys;
import dev.aurelium.auraskills.acf.PaperCommandManager;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.common.message.MessageKey;
import dev.aurelium.auraskills.common.message.MessageProvider;
import dev.aurelium.auraskills.common.message.type.ACFCoreMessage;
import dev.aurelium.auraskills.common.message.type.ACFMinecraftMessage;
import dev.aurelium.auraskills.kyori.adventure.text.Component;
import dev.aurelium.auraskills.slate.text.TextFormatter;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class BukkitMessageProvider
extends MessageProvider {
    private final TextFormatter textFormatter = new TextFormatter();

    public BukkitMessageProvider(AuraSkills plugin) {
        super(plugin);
    }

    @Override
    public String applyFormatting(String message) {
        return this.textFormatter.toString(this.textFormatter.toComponent(message));
    }

    @Override
    public String componentToString(Component component) {
        return this.textFormatter.toString(component);
    }

    @Override
    public Component stringToComponent(String message) {
        return this.textFormatter.toComponent(message);
    }

    public void setACFMessages(@NotNull PaperCommandManager commandManager) {
        for (Locale locale : this.manager.getLoadedLanguages()) {
            String configMsg;
            for (ACFCoreMessage aCFCoreMessage : ACFCoreMessage.values()) {
                configMsg = this.get(aCFCoreMessage, locale);
                commandManager.getLocales().addMessage(locale, MessageKeys.valueOf(aCFCoreMessage.name()), configMsg);
            }
            for (Enum enum_ : ACFMinecraftMessage.values()) {
                configMsg = this.get((MessageKey)((Object)enum_), locale);
                commandManager.getLocales().addMessage(locale, MinecraftMessageKeys.valueOf(enum_.name()), configMsg);
            }
        }
    }
}

