/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.menus.util;

import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.slate.menu.LoadedMenu;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;

public class LevelProgressionOpener {
    private final AuraSkills plugin;

    public LevelProgressionOpener(AuraSkills plugin) {
        this.plugin = plugin;
    }

    public void open(Player player, Skill skill) {
        User user = this.plugin.getUser(player);
        int page = this.getPage(skill, user);
        ConcurrentHashMap<String, Object> properties = new ConcurrentHashMap<String, Object>();
        properties.put("skill", skill);
        properties.put("previous_menu", "skills");
        this.plugin.getSlate().openMenu(player, "level_progression", properties, page);
    }

    public int getPage(Skill skill, User user) {
        int maxLevelPage;
        int page;
        int itemsPerPage = 24;
        int startLevel = 1;
        LoadedMenu menu = this.plugin.getSlate().getLoadedMenu("level_progression");
        if (menu != null) {
            itemsPerPage = (Integer)menu.options().getOrDefault("items_per_page", 24);
            startLevel = (Integer)menu.options().getOrDefault("start_level", 1);
        }
        if ((page = (user.getSkillLevel(skill) - startLevel + 1) / itemsPerPage) > (maxLevelPage = (skill.getMaxLevel() - startLevel) / itemsPerPage)) {
            page = maxLevelPage;
        }
        return page;
    }
}

