/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.menus.shared;

import dev.aurelium.auraskills.api.ability.Ability;
import dev.aurelium.auraskills.api.mana.CustomManaAbility;
import dev.aurelium.auraskills.api.mana.ManaAbilities;
import dev.aurelium.auraskills.api.mana.ManaAbility;
import dev.aurelium.auraskills.api.skill.CustomSkill;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.menus.shared.ModifierInstances;
import dev.aurelium.auraskills.bukkit.menus.util.PlaceholderHelper;
import dev.aurelium.auraskills.bukkit.util.ConfigurateItemParser;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.message.type.MenuMessage;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.math.RomanNumber;
import dev.aurelium.auraskills.common.util.text.Replacer;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import dev.aurelium.auraskills.configurate.serialize.SerializationException;
import dev.aurelium.auraskills.slate.builder.MenuBuilder;
import dev.aurelium.auraskills.slate.builder.TemplateBuilder;
import dev.aurelium.auraskills.slate.info.TemplateInfo;
import dev.aurelium.auraskills.slate.item.MenuItem;
import dev.aurelium.auraskills.slate.item.TemplateItem;
import dev.aurelium.auraskills.slate.item.provider.ListBuilder;
import dev.aurelium.auraskills.slate.menu.LoadedMenu;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class SkillItem {
    private final AuraSkills plugin;
    private final PlaceholderHelper helper;
    private static NumberFormat percentFormat = new DecimalFormat("#.##");
    private static NumberFormat currentXpFormat = new DecimalFormat("#.##");

    public SkillItem(AuraSkills plugin) {
        this.plugin = plugin;
        this.helper = new PlaceholderHelper(plugin);
    }

    public static void loadFormats(AuraSkills plugin) {
        Object currentXpFormatObj;
        LoadedMenu menu = plugin.getSlate().getLoadedMenu("skills");
        if (menu == null) {
            return;
        }
        Object percentFormatObj = menu.options().get("percent_format");
        if (percentFormatObj instanceof String) {
            String s = (String)percentFormatObj;
            percentFormat = new DecimalFormat(s);
        }
        if ((currentXpFormatObj = menu.options().get("current_xp_format")) instanceof String) {
            String s = (String)currentXpFormatObj;
            currentXpFormat = new DecimalFormat(s);
        }
    }

    public void baseSkillItem(TemplateBuilder<Skill> template) {
        template.replace("skill", p -> ((Skill)p.value()).getDisplayName(p.locale(), false));
        template.replace("desc", p -> ((Skill)p.value()).getDescription(p.locale(), false));
        template.replace("level", p -> RomanNumber.toRoman(this.plugin.getUser(p.player()).getSkillLevel((Skill)p.value()), this.plugin));
        template.replace("skill_click", p -> this.plugin.getMsg(MenuMessage.SKILL_CLICK, p.locale()));
        template.modify(t -> {
            if (!((Skill)t.value()).isEnabled()) {
                return null;
            }
            ItemStack item = t.item();
            Object patt0$temp = t.value();
            if (patt0$temp instanceof CustomSkill) {
                CustomSkill customSkill = (CustomSkill)patt0$temp;
                try {
                    ConfigurateItemParser parser = new ConfigurateItemParser(this.plugin);
                    item = parser.parseBaseItem(parser.parseItemContext(customSkill.getDefined().getItem()));
                }
                catch (SerializationException | IllegalArgumentException e) {
                    this.plugin.logger().warn("Error parsing ItemContext of CustomSkill " + String.valueOf(customSkill.getId()));
                    e.printStackTrace();
                }
            }
            this.addSelectedJobGlint(item, t);
            return item;
        });
    }

    private void addSelectedJobGlint(ItemStack item, TemplateInfo<Skill> t) {
        ItemMeta meta;
        if (!t.menu().getName().equals("skills")) {
            return;
        }
        if (!this.plugin.config().jobSelectionEnabled()) {
            return;
        }
        User user = this.plugin.getUser(t.player());
        Skill skill = t.value();
        if (user.getJobs().contains(skill) && (meta = item.getItemMeta()) != null) {
            meta.addEnchant(Enchantment.MENDING, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            item.setItemMeta(meta);
        }
    }

    public void buildComponents(MenuBuilder menu) {
        this.statsLeveled(menu);
        this.abilityLevels(menu);
        this.manaAbilityInfo(menu);
        this.progress(menu);
        this.maxLevel(menu);
        this.skillJobActive(menu);
    }

    private void skillJobActive(MenuBuilder menu) {
        menu.component("skill_job_active", Skill.class, component -> component.shouldShow(t -> this.plugin.config().jobSelectionEnabled() && this.plugin.getUser(t.player()).getJobs().contains(t.value())));
    }

    public void statsLeveled(MenuBuilder menu) {
        menu.component("stats_leveled", Skill.class, component -> {
            component.replace("entries", p -> {
                String entry = p.menu().getFormat("stat_leveled_entry");
                ListBuilder builder = new ListBuilder(p.data().listData());
                Locale locale = p.locale();
                for (Stat stat : this.plugin.getRewardManager().getRewardTable((Skill)p.value()).getStatsLeveled()) {
                    builder.append(entry, "{color}", stat.getColor(locale), "{stat}", stat.getDisplayName(locale, false));
                }
                return builder.build();
            });
            component.shouldShow(t -> !this.plugin.getRewardManager().getRewardTable((Skill)t.value()).getStatsLeveled().isEmpty());
        });
    }

    public void abilityLevels(MenuBuilder menu) {
        menu.component("ability_levels", Skill.class, component -> {
            component.replace("entries", p -> {
                Locale locale = p.locale();
                ListBuilder builder = new ListBuilder(p.data().listData());
                for (Ability ability : ((Skill)p.value()).getAbilities()) {
                    if (!ability.isEnabled()) continue;
                    int level = this.plugin.getUser(p.player()).getAbilityLevel(ability);
                    String entry = level > 0 ? p.menu().getFormat("unlocked_ability_entry") : p.menu().getFormat("locked_ability_entry");
                    builder.append(entry, "{name}", ability.getDisplayName(locale, false), "{level}", RomanNumber.toRoman(level, this.plugin), "{info}", TextUtil.replace(ability.getInfo(locale, false), "{value}", NumberUtil.format2(ability.getValue(level)), "{value_2}", NumberUtil.format2(ability.getSecondaryValue(level)), "{chance_value}", this.plugin.getAbilityManager().getChanceValue(ability, level), "{guaranteed_value}", this.plugin.getAbilityManager().getGuaranteedValue(ability, level)));
                }
                return builder.build();
            });
            component.shouldShow(t -> !((Skill)t.value()).getAbilities().isEmpty());
        });
    }

    public void manaAbilityInfo(MenuBuilder menu) {
        menu.component("mana_ability_info", Skill.class, component -> {
            component.replace("name", p -> {
                ManaAbility manaAbility = ((Skill)p.value()).getManaAbility();
                return manaAbility != null ? manaAbility.getDisplayName(p.locale(), false) : null;
            });
            component.replace("level", p -> {
                ManaAbility manaAbility = ((Skill)p.value()).getManaAbility();
                if (manaAbility == null) {
                    return null;
                }
                return RomanNumber.toRoman(this.plugin.getUser(p.player()).getManaAbilityLevel(manaAbility), this.plugin);
            });
            component.replace("entries", p -> {
                ManaAbility manaAbility = ((Skill)p.value()).getManaAbility();
                if (manaAbility == null) {
                    return null;
                }
                ListBuilder builder = new ListBuilder(p.data().listData());
                int level = this.plugin.getUser(p.player()).getManaAbilityLevel(manaAbility);
                block11: for (String format : this.getFormatEntries(manaAbility)) {
                    String message = this.helper.replaceMenuMessages(p.menu().getFormat(format), p.player(), p.menu(), new Replacer());
                    switch (format) {
                        case "duration_entry": {
                            builder.append(message, "{duration}", NumberUtil.format1(this.getDuration(manaAbility, level)));
                            continue block11;
                        }
                        case "mana_cost_entry": 
                        case "max_mana_cost_entry": {
                            if (!this.plugin.configBoolean(Option.MANA_ENABLED)) continue block11;
                            builder.append(message, "{mana_cost}", NumberUtil.format1(manaAbility.getManaCost(level)));
                            continue block11;
                        }
                        case "cooldown_entry": {
                            builder.append(message, "{cooldown}", NumberUtil.format1(manaAbility.getCooldown(level)));
                            continue block11;
                        }
                    }
                    builder.append(message, "{value}", NumberUtil.format1(manaAbility.getValue(level)));
                }
                return builder.build();
            });
            component.shouldShow(t -> {
                ManaAbility manaAbility = ((Skill)t.value()).getManaAbility();
                return manaAbility != null && manaAbility.isEnabled() && this.plugin.getUser(t.player()).getManaAbilityLevel(manaAbility) > 0;
            });
        });
    }

    public void progress(MenuBuilder menu) {
        menu.component("progress", Skill.class, component -> {
            component.replaceAny(p -> {
                User user = this.plugin.getUser(p.player());
                int skillLevel = user.getSkillLevel((Skill)p.value());
                double currentXp = user.getSkillXp((Skill)p.value());
                double xpToNext = this.plugin.getXpRequirements().getXpRequired((Skill)p.value(), skillLevel + 1);
                return switch (p.placeholder()) {
                    case "next_level" -> RomanNumber.toRoman(skillLevel + 1, this.plugin);
                    case "percent" -> percentFormat.format(currentXp / xpToNext * 100.0);
                    case "current_xp" -> currentXpFormat.format(currentXp);
                    case "level_xp" -> String.valueOf((int)xpToNext);
                    case "bar" -> SkillItem.getBar(this.plugin, currentXp, xpToNext);
                    default -> null;
                };
            });
            component.shouldShow(t -> ((Skill)t.value()).getMaxLevel() > this.plugin.getUser(t.player()).getSkillLevel((Skill)t.value()));
        });
    }

    public void maxLevel(MenuBuilder menu) {
        menu.component("max_level", Skill.class, component -> component.shouldShow(t -> ((Skill)t.value()).getMaxLevel() == this.plugin.getUser(t.player()).getSkillLevel((Skill)t.value())));
    }

    public static String getBar(AuraSkills plugin, double currentXp, double xpToNext) {
        LoadedMenu menu = plugin.getSlate().getLoadedMenu("skills");
        if (menu == null) {
            return "";
        }
        int length = (Integer)menu.options().getOrDefault("bar_length", 10);
        double progress = Math.min(currentXp / xpToNext, 1.0);
        int currentPos = (int)Math.round(progress * (double)(length - 1));
        StringBuilder bar = new StringBuilder();
        String completed = menu.formats().getOrDefault("bar_completed", "<green>\u25a0");
        bar.append(completed.repeat(Math.max(0, currentPos)));
        bar.append(menu.formats().getOrDefault("bar_current", "<yellow>\u25a0"));
        String remaining = menu.formats().getOrDefault("bar_remaining", "<gray>\u25a0");
        bar.append(remaining.repeat(Math.max(0, length - currentPos - 1)));
        return bar.toString();
    }

    private double getDuration(ManaAbility manaAbility, int level) {
        if (manaAbility.equals(ManaAbilities.LIGHTNING_BLADE)) {
            double baseDuration = ManaAbilities.LIGHTNING_BLADE.optionDouble("base_duration", 5.0);
            double durationPerLevel = ManaAbilities.LIGHTNING_BLADE.optionDouble("duration_per_level", 4.0);
            return baseDuration + durationPerLevel * (double)(level - 1);
        }
        return manaAbility.getValue(level);
    }

    private List<String> getFormatEntries(ManaAbility manaAbility) {
        CustomManaAbility custom;
        if (manaAbility.equals(ManaAbilities.SHARP_HOOK)) {
            return List.of("damage_entry", "mana_cost_entry", "cooldown_entry");
        }
        if (manaAbility.equals(ManaAbilities.CHARGED_SHOT)) {
            return List.of("damage_per_mana_entry", "max_mana_cost_entry");
        }
        if (manaAbility.equals(ManaAbilities.LIGHTNING_BLADE)) {
            return List.of("attack_speed_entry", "duration_entry", "mana_cost_entry", "cooldown_entry");
        }
        if (manaAbility instanceof CustomManaAbility && !(custom = (CustomManaAbility)manaAbility).getInfoFormats().isEmpty()) {
            return custom.getInfoFormats();
        }
        return List.of("duration_entry", "mana_cost_entry", "cooldown_entry");
    }

    @NotNull
    public static ItemStack getBaseItem(Skill skill, AuraSkillsPlugin pluginAbs) {
        MenuItem menuItem;
        ItemStack item = null;
        if (!(pluginAbs instanceof AuraSkills)) {
            return ModifierInstances.getFallbackItem();
        }
        AuraSkills plugin = (AuraSkills)pluginAbs;
        LoadedMenu loadedMenu = plugin.getSlate().getLoadedMenu("skills");
        if (loadedMenu != null && (menuItem = loadedMenu.items().get("skill")) instanceof TemplateItem) {
            TemplateItem template = (TemplateItem)menuItem;
            ItemStack baseItem = template.getBaseItems().get(skill);
            if (baseItem == null) {
                baseItem = template.getDefaultBaseItem();
            }
            item = baseItem;
        }
        if (item == null) {
            item = ModifierInstances.getFallbackItem();
        }
        return item;
    }
}

