/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.menus.shared;

import dev.aurelium.auraskills.api.registry.NamespaceIdentified;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.TraitModifier;
import dev.aurelium.auraskills.api.util.AuraSkillsModifier;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.item.BuiltInModifier;
import dev.aurelium.auraskills.bukkit.item.StatModifiers;
import dev.aurelium.auraskills.bukkit.item.TraitModifiers;
import dev.aurelium.auraskills.bukkit.menus.shared.ModifierInstance;
import dev.aurelium.auraskills.bukkit.menus.shared.SkillItem;
import dev.aurelium.auraskills.bukkit.user.BukkitUser;
import dev.aurelium.auraskills.bukkit.util.VersionUtils;
import dev.aurelium.auraskills.common.message.MessageKey;
import dev.aurelium.auraskills.common.message.type.MenuMessage;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Nullable;

public class ModifierInstances {
    private static final String STAT_PREFIX = "stat_modifier_";
    private static final String TRAIT_PREFIX = "trait_modifier_";
    private final AuraSkills plugin;

    public ModifierInstances(AuraSkills plugin) {
        this.plugin = plugin;
    }

    public Map<String, ModifierInstance> getInstances(User user, NamespaceIdentified parent) {
        return this.getInstances(user, parent, false);
    }

    public Map<String, ModifierInstance> getInstances(User user, NamespaceIdentified parent, boolean excludeLinkedStats) {
        if (parent instanceof Stat) {
            Stat stat = (Stat)parent;
            return this.getStatInstances(user, stat);
        }
        if (parent instanceof Trait) {
            Trait trait = (Trait)parent;
            return this.getTraitInstances(user, excludeLinkedStats, trait);
        }
        return new ConcurrentHashMap<String, ModifierInstance>();
    }

    public Map<String, ModifierInstance> sortAndReindex(Map<String, ModifierInstance> instances) {
        ArrayList<ModifierInstance> sortedList = new ArrayList<ModifierInstance>(instances.values());
        sortedList.sort(Comparator.comparingInt(m -> switch (m.operation()) {
            default -> throw new MatchException(null, null);
            case AuraSkillsModifier.Operation.ADD -> 0;
            case AuraSkillsModifier.Operation.ADD_PERCENT -> 1;
            case AuraSkillsModifier.Operation.MULTIPLY -> 2;
        }).thenComparing(Comparator.comparingDouble(ModifierInstance::value).reversed()));
        ConcurrentHashMap<String, ModifierInstance> reindexedList = new ConcurrentHashMap<String, ModifierInstance>();
        for (int i = 0; i < sortedList.size(); ++i) {
            ModifierInstance indexed = ((ModifierInstance)sortedList.get(i)).withIndex(i);
            reindexedList.put(indexed.id(), indexed);
        }
        return reindexedList;
    }

    private Map<String, ModifierInstance> getTraitInstances(User user, boolean excludeLinkedStats, Trait trait) {
        ConcurrentHashMap<String, ModifierInstance> instances = new ConcurrentHashMap<String, ModifierInstance>();
        int index = 0;
        double base = this.plugin.getTraitManager().getBaseLevel(user, trait);
        if (base >= 1.0E-5) {
            String id = "base_level_" + trait.getId().getSimpleName();
            instances.put(id, new ModifierInstance(trait, id, base, AuraSkillsModifier.Operation.ADD, ModifierInstances.getFallbackItem(), this.plugin.getMsg(MenuMessage.BASE_LEVEL, user.getLocale()), this.plugin.getMsg(MenuMessage.BASE_LEVEL_DESC, user.getLocale()), index));
            ++index;
        }
        if (!excludeLinkedStats) {
            for (Stat stat : this.plugin.getTraitManager().getLinkedStats(trait)) {
                double modifier = stat.getTraitModifier(trait);
                double level = user.getStatLevel(stat);
                if (level == 0.0) continue;
                String id = "linked_stat_" + stat.getId().getSimpleName();
                instances.put(id, new ModifierInstance(trait, id, level * modifier, AuraSkillsModifier.Operation.ADD, ModifierInstances.getFallbackItem(), stat.getDisplayName(user.getLocale()), this.plugin.getMsg(MenuMessage.LINKED_STAT_DESC, user.getLocale()).replace("{stat}", stat.getDisplayName(user.getLocale())), index));
                ++index;
            }
        }
        for (TraitModifier modifier : user.getTraitModifiers().values()) {
            if (!modifier.trait().equals(trait) || modifier.value() == 0.0) continue;
            TraitModifiers builtIn = TraitModifiers.fromId(modifier.name());
            String id = builtIn != null ? "ability_" + builtIn.getMessageName() : TRAIT_PREFIX + modifier.name();
            instances.put(id, this.createInstance(trait, id, modifier, builtIn, user, index));
            ++index;
        }
        return instances;
    }

    private Map<String, ModifierInstance> getStatInstances(User user, Stat stat) {
        ConcurrentHashMap<String, ModifierInstance> instances = new ConcurrentHashMap<String, ModifierInstance>();
        int index = 0;
        for (Map.Entry<Skill, Double> entry : user.getUserStats().getLevelRewardedBySkill(stat).entrySet()) {
            if (entry.getValue() == 0.0) continue;
            String id = "stat_reward_" + entry.getKey().getId().getSimpleName();
            instances.put(id, new ModifierInstance(stat, id, entry.getValue(), AuraSkillsModifier.Operation.ADD, SkillItem.getBaseItem(entry.getKey(), user.getPlugin()), entry.getKey().getDisplayName(user.getLocale()), this.plugin.getMsg(MenuMessage.STAT_REWARD_DESC, user.getLocale()).replace("{skill}", entry.getKey().getDisplayName(user.getLocale())), index));
            ++index;
        }
        for (StatModifier modifier : user.getStatModifiers().values()) {
            if (!modifier.stat().equals(stat) || modifier.value() == 0.0) continue;
            StatModifiers builtIn = StatModifiers.fromId(modifier.name());
            String id = builtIn != null ? "ability_" + builtIn.getMessageName() : STAT_PREFIX + modifier.name();
            instances.put(id, this.createInstance(stat, id, modifier, builtIn, user, index));
            ++index;
        }
        return instances;
    }

    private ModifierInstance createInstance(NamespaceIdentified identified, String id, AuraSkillsModifier<?> modifier, BuiltInModifier builtIn, User user, int index) {
        @Nullable ItemModifierData itemData = this.getItemModifierData(user, id);
        String displayName = builtIn != null ? builtIn.getDisplayName(this.plugin, user.getLocale()) : (itemData != null ? itemData.displayName() : modifier.name());
        String desc = builtIn != null ? builtIn.getDescriptionMessage(this.plugin, user) : (itemData != null ? itemData.description() : this.getFallbackDescription(id, user.getLocale()));
        return new ModifierInstance(identified, id, modifier.value(), modifier.operation(), itemData != null ? itemData.item() : ModifierInstances.getFallbackItem(), displayName, desc, index);
    }

    @Nullable
    private ItemModifierData getItemModifierData(User user, String id) {
        ItemMeta meta;
        ItemStack item;
        MenuMessage descKey;
        Player player = ((BukkitUser)user).getPlayer();
        if (player == null) {
            return null;
        }
        if (id.startsWith("stat_modifier_AuraSkills.Modifiers.Item.") || id.startsWith("trait_modifier_AuraSkills.TraitModifiers.Item.")) {
            if (id.endsWith(".Offhand")) {
                descKey = MenuMessage.ITEM_OFF_HAND_DESC;
                item = player.getInventory().getItemInOffHand();
            } else {
                descKey = MenuMessage.ITEM_HAND_DESC;
                item = player.getInventory().getItemInMainHand();
            }
        } else if (id.startsWith("stat_modifier_AuraSkills.Modifiers.Armor.") || id.startsWith("trait_modifier_AuraSkills.TraitModifiers.Armor.")) {
            String withoutPrefix = TextUtil.replace(id, STAT_PREFIX, "", TRAIT_PREFIX, "", "AuraSkills.Modifiers.", "", "AuraSkills.TraitModifiers.", "", "Armor.", "");
            String slotName = withoutPrefix.split("\\.", 2)[0];
            try {
                descKey = MenuMessage.valueOf(slotName.toUpperCase(Locale.ROOT) + "_DESC");
                item = switch (slotName.toLowerCase(Locale.ROOT)) {
                    case "helmet" -> player.getInventory().getHelmet();
                    case "chestplate" -> player.getInventory().getChestplate();
                    case "leggings" -> player.getInventory().getLeggings();
                    case "boots" -> player.getInventory().getBoots();
                    default -> null;
                };
            }
            catch (IllegalArgumentException ignored) {
                return null;
            }
        } else {
            return null;
        }
        if (item == null) {
            item = ModifierInstances.getFallbackItem();
        }
        if ((meta = (item = item.clone()).getItemMeta()) != null) {
            if (VersionUtils.isAtLeastVersion(20, 5)) {
                meta.setAttributeModifiers(Material.IRON_SWORD.getDefaultAttributeModifiers(EquipmentSlot.HAND));
            }
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            meta.setLore(null);
            item.setItemMeta(meta);
        }
        return new ItemModifierData(this.getDisplayName(item), this.plugin.getMsg(descKey, user.getLocale()), item);
    }

    private String getDisplayName(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        return meta == null || !meta.hasDisplayName() ? "!!REMOVE!!" : meta.getDisplayName();
    }

    private String getFallbackDescription(String modifierName, Locale locale) {
        String path = "menus.stat_info.modifiers." + modifierName;
        String customMsg = this.plugin.getMsg(MessageKey.of(path), locale);
        if (!customMsg.equals(path)) {
            return customMsg;
        }
        return this.plugin.getMsg(MenuMessage.CUSTOM_MODIFIER_DESC, locale);
    }

    public static ItemStack getFallbackItem() {
        return new ItemStack(Material.GRAY_DYE);
    }

    record ItemModifierData(String displayName, String description, ItemStack item) {
    }
}

