/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.menus;

import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.skill.Skills;
import dev.aurelium.auraskills.api.source.XpSource;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.menus.shared.GlobalItems;
import dev.aurelium.auraskills.bukkit.menus.util.SourceComparator;
import dev.aurelium.auraskills.common.message.type.MenuMessage;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.data.DataUtil;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import dev.aurelium.auraskills.slate.builder.MenuBuilder;
import dev.aurelium.auraskills.slate.info.PlaceholderInfo;
import dev.aurelium.auraskills.slate.inv.content.SlotPos;
import dev.aurelium.auraskills.slate.item.provider.ListBuilder;
import dev.aurelium.auraskills.slate.menu.ActiveMenu;
import dev.aurelium.auraskills.slate.menu.LoadedMenu;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SourcesMenu {
    public static final int DEF_ITEMS_PER_PAGE = 28;
    public static final String DEF_SOURCE_START = "1,1";
    public static final String DEF_SOURCE_END = "4,8";
    private final List<Integer> track;
    private NumberFormat xpFormat = new DecimalFormat("#.##");
    private NumberFormat moneyFormat = new DecimalFormat("0.00");
    private final AuraSkills plugin;

    public SourcesMenu(AuraSkills plugin) {
        this.plugin = plugin;
        this.track = new ArrayList<Integer>();
    }

    private void initTrack() {
        Object moneyFormatObj;
        Object xpFormatObj;
        LoadedMenu menu = this.plugin.getSlate().getLoadedMenu("sources");
        if (menu == null) {
            return;
        }
        Object trackObj = menu.options().get("track");
        if (trackObj != null) {
            this.track.clear();
            this.track.addAll(DataUtil.castIntegerList(trackObj));
        }
        if ((xpFormatObj = menu.options().get("xp_format")) instanceof String) {
            String s = (String)xpFormatObj;
            this.xpFormat = new DecimalFormat(s);
        }
        if ((moneyFormatObj = menu.options().get("money_format")) instanceof String) {
            String s = (String)moneyFormatObj;
            this.moneyFormat = new DecimalFormat(s);
        }
    }

    public void build(MenuBuilder menu) {
        menu.onOpen(m -> this.initTrack());
        menu.defaultOptions(Map.of("source_start", DEF_SOURCE_START, "source_end", DEF_SOURCE_END, "items_per_page", 28, "use_track", false, "track", new int[0], "xp_format", "#.##", "income_format", "0.00"));
        menu.replaceTitle("current_page", p -> String.valueOf(p.menu().getCurrentPage() + 1));
        menu.replaceTitle("total_pages", p -> String.valueOf(p.menu().getTotalPages()));
        menu.replaceTitle("skill", p -> ((Skill)p.menu().getProperty("skill")).getDisplayName(p.locale(), false));
        menu.pages(m -> {
            Skill skill = (Skill)m.menu().getProperty("skill");
            int itemsPerPage = (Integer)m.menu().getProperty("items_per_page");
            int numSources = this.plugin.getSkillManager().getSkill(skill).sources().size();
            return (numSources - 1) / itemsPerPage + 1;
        });
        menu.properties(m -> Map.of("skill", m.menu().getProperty("skill", Skills.FARMING), "items_per_page", this.getItemsPerPage(), "sort_type", SortType.ASCENDING, "previous_menu", "level_progression"));
        GlobalItems globalItems = new GlobalItems(this.plugin);
        menu.item("back", globalItems::backToLevelProgression);
        menu.item("previous_page", globalItems::previousPage);
        menu.item("next_page", globalItems::nextPage);
        menu.fillItem(globalItems::fill);
        menu.item("sorter", item -> {
            item.replace("sort_types", this::getSortedTypesLore);
            item.onClick(c -> {
                SortType[] types = SortType.values();
                SortType current = (SortType)((Object)((Object)((Object)c.menu().getProperty("sort_type"))));
                int currentTypeIndex = 0;
                for (int i = 0; i < types.length; ++i) {
                    SortType type = types[i];
                    if (type != current) continue;
                    currentTypeIndex = i;
                }
                SortType nextType = currentTypeIndex < types.length - 1 ? types[currentTypeIndex + 1] : types[0];
                c.menu().setProperty("sort_type", (Object)nextType);
                c.menu().reload();
                c.menu().setCooldown("sorter", 5);
            });
        });
        menu.template("source", XpSource.class, template -> {
            template.replace("source_name", p -> ((XpSource)p.value()).getDisplayName(p.locale()));
            template.replace("source_xp", p -> {
                XpSource source = (XpSource)p.value();
                String unitName = source.getUnitName(p.locale());
                return TextUtil.replace(unitName == null ? p.menu().getFormat("source_xp") : p.menu().getFormat("source_xp_rate"), "{xp}", this.xpFormat.format(source.getXp()), "{unit}", unitName);
            });
            template.replace("income", p -> {
                XpSource source = (XpSource)p.value();
                Skill skill = (Skill)p.menu().getProperty("skill");
                double xp = this.getMultipliedXpValue((XpSource)p.value(), p.menu(), p.player());
                return this.moneyFormat.format(source.getIncome().getIncomeEarned(this.plugin.getUser(p.player()).toApi(), source.getValues(), skill, xp));
            });
            template.slotPos(t -> {
                int index = this.getSortedSources(t.menu()).indexOf(t.value());
                if (index != -1) {
                    boolean useTrack = t.menu().getOption(Boolean.class, "use_track", false);
                    if (useTrack) {
                        if (index < this.track.size()) {
                            int pos = this.track.get(index);
                            return SlotPos.of(pos / 9, pos % 9);
                        }
                    } else {
                        SlotPos start = this.parsePos(t.menu().getOption(String.class, "source_start", DEF_SOURCE_START));
                        SlotPos end = this.parsePos(t.menu().getOption(String.class, "source_end", DEF_SOURCE_END));
                        int numRows = end.getRow() - start.getRow();
                        int numCols = end.getColumn() - start.getColumn();
                        int row = Math.min(start.getRow() + index / numCols, start.getRow() + numRows);
                        int column = start.getColumn() + index % numCols;
                        return SlotPos.of(row, column);
                    }
                }
                return null;
            });
            template.definedContexts(m -> {
                ActiveMenu activeMenu = m.menu();
                int itemsPerPage = (Integer)activeMenu.getProperty("items_per_page");
                int page = activeMenu.getCurrentPage();
                ArrayList<XpSource> filteredSources = new ArrayList<XpSource>();
                for (XpSource source : ((Skill)activeMenu.getProperty("skill")).getSources()) {
                    if (source.getXp() == 0.0 || this.plugin.getItemRegistry().getSourceMenuItems().getMenuItem(source) == null) continue;
                    filteredSources.add(source);
                }
                filteredSources.sort(((SortType)((Object)((Object)((Object)activeMenu.getProperty("sort_type"))))).getComparator(this.plugin, m.locale()));
                int toIndex = Math.min((page + 1) * itemsPerPage, filteredSources.size());
                List shownSources = filteredSources.subList(page * itemsPerPage, toIndex);
                activeMenu.setProperty("sources", shownSources);
                return new HashSet(shownSources);
            });
            template.modify(t -> {
                if (t.item().getType() != Material.GRAY_DYE) {
                    return t.item();
                }
                ItemStack item = (ItemStack)this.plugin.getItemRegistry().getSourceMenuItems().getMenuItem((XpSource)t.value());
                if (item == null) {
                    this.plugin.logger().warn("Item of source " + String.valueOf(((XpSource)t.value()).getId()) + " not found");
                }
                return item;
            });
        });
        menu.component("multiplied_xp", XpSource.class, component -> {
            component.replace("source_xp", p -> {
                double value = this.getMultipliedXpValue((XpSource)p.value(), p.menu(), p.player());
                String unitName = ((XpSource)p.value()).getUnitName(p.locale());
                return TextUtil.replace(unitName == null ? p.menu().getFormat("source_xp") : p.menu().getFormat("source_xp_rate"), "{xp}", this.xpFormat.format(value), "{unit}", unitName);
            });
            component.shouldShow(t -> this.getMultiplier(t.player(), (Skill)t.menu().getProperty("skill")) > 1.0);
        });
    }

    private double getMultipliedXpValue(XpSource xpSource, ActiveMenu activeMenu, Player player) {
        double multiplier = this.getMultiplier(player, (Skill)activeMenu.getProperty("skill"));
        return xpSource.getXp() * multiplier;
    }

    private double getMultiplier(Player player, Skill skill) {
        User user = this.plugin.getUser(player);
        double permissionMultiplier = 1.0 + this.plugin.getLevelManager().getPermissionMultiplier(user, skill);
        return this.plugin.getLevelManager().getAbilityMultiplier(user, skill) * permissionMultiplier;
    }

    private int getItemsPerPage() {
        LoadedMenu menu = this.plugin.getSlate().getLoadedMenu("sources");
        if (menu != null) {
            return (Integer)menu.options().getOrDefault("items_per_page", 28);
        }
        return 28;
    }

    private String getSortedTypesLore(PlaceholderInfo info) {
        ListBuilder builder = new ListBuilder(info.data().listData());
        SortType selected = (SortType)((Object)info.menu().getProperty("sort_type"));
        for (SortType sortType : SortType.values()) {
            String typeString = TextUtil.replace(info.menu().getFormat("sort_type_entry"), "{type_name}", this.plugin.getMsg(MenuMessage.valueOf(sortType.toString()), info.locale()));
            typeString = selected == sortType ? TextUtil.replace(typeString, "{selected}", info.menu().getFormat("selected")) : TextUtil.replace(typeString, "{selected}", "");
            builder.append(typeString, new String[0]);
        }
        return builder.build();
    }

    private List<XpSource> getSortedSources(ActiveMenu activeMenu) {
        Object object = activeMenu.getProperty("sources");
        ArrayList<XpSource> sources = new ArrayList<XpSource>();
        if (object instanceof List) {
            List list = (List)object;
            for (Object element : list) {
                if (!(element instanceof XpSource)) continue;
                sources.add((XpSource)element);
            }
        }
        return sources;
    }

    private SlotPos parsePos(String input) {
        String[] split = input.split(",");
        if (split.length == 2) {
            return SlotPos.of(NumberUtil.toInt(split[0]), NumberUtil.toInt(split[1]));
        }
        return SlotPos.of(0, 0);
    }

    public static enum SortType {
        ASCENDING,
        DESCENDING,
        ALPHABETICAL,
        REVERSE_ALPHABETICAL;


        public SourceComparator getComparator(AuraSkills plugin, Locale locale) {
            return switch (this.ordinal()) {
                case 1 -> new SourceComparator.Descending(plugin);
                case 2 -> new SourceComparator.Alphabetical(plugin, locale);
                case 3 -> new SourceComparator.ReverseAlphabetical(plugin, locale);
                default -> new SourceComparator.Ascending(plugin);
            };
        }
    }
}

