/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.menus;

import com.google.common.collect.ImmutableList;
import dev.aurelium.auraskills.api.ability.Ability;
import dev.aurelium.auraskills.api.mana.ManaAbilities;
import dev.aurelium.auraskills.api.mana.ManaAbility;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.skill.Skills;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.menus.shared.GlobalItems;
import dev.aurelium.auraskills.bukkit.menus.shared.SkillItem;
import dev.aurelium.auraskills.bukkit.menus.shared.SkillLevelItem;
import dev.aurelium.auraskills.common.ability.AbilityUtil;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.reward.SkillReward;
import dev.aurelium.auraskills.common.reward.type.MoneyReward;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.math.RomanNumber;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import dev.aurelium.auraskills.slate.action.trigger.ClickTrigger;
import dev.aurelium.auraskills.slate.builder.BuiltMenu;
import dev.aurelium.auraskills.slate.builder.MenuBuilder;
import dev.aurelium.auraskills.slate.builder.TemplateBuilder;
import dev.aurelium.auraskills.slate.info.ComponentPlaceholderInfo;
import dev.aurelium.auraskills.slate.info.MenuInfo;
import dev.aurelium.auraskills.slate.info.TemplatePlaceholderInfo;
import dev.aurelium.auraskills.slate.menu.LoadedMenu;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.entity.Player;

public class LevelProgressionMenu {
    private final AuraSkills plugin;

    public LevelProgressionMenu(AuraSkills plugin) {
        this.plugin = plugin;
    }

    public void build(MenuBuilder menu) {
        menu.defaultOptions(Map.of("use_level_as_amount", false, "over_max_stack_amount", 1, "items_per_page", 24, "start_level", 1, "track", SkillLevelItem.getDefaultTrack()));
        menu.replace("skill", p -> ((Skill)p.menu().getProperty("skill")).getDisplayName(p.locale(), false));
        menu.replace("skill_key", p -> ((Skill)p.menu().getProperty("skill")).getId().getKey());
        menu.replaceTitle("page", p -> String.valueOf(p.menu().getCurrentPage() + 1));
        menu.properties(m -> {
            int itemsPerPage = 24;
            LoadedMenu loadedMenu = this.plugin.getSlate().getLoadedMenu("level_progression");
            if (loadedMenu != null) {
                itemsPerPage = (Integer)loadedMenu.options().getOrDefault("items_per_page", 24);
            }
            return Map.of("skill", m.menu().getProperty("skill", Skills.FARMING), "items_per_page", itemsPerPage, "previous_menu", "skills");
        });
        menu.pages(m -> {
            Object itemsPerPageObj;
            Skill skill = (Skill)m.menu().getProperty("skill");
            int itemsPerPage = 24;
            LoadedMenu levelProgressionMenu = this.plugin.getSlate().getLoadedMenu("level_progression");
            if (levelProgressionMenu != null && (itemsPerPageObj = levelProgressionMenu.options().get("items_per_page")) != null) {
                itemsPerPage = (Integer)itemsPerPageObj;
            }
            int startLevel = m.menu().getOption(Integer.class, "start_level", 1);
            return (skill.getMaxLevel() - startLevel) / itemsPerPage + 1;
        });
        GlobalItems globalItems = new GlobalItems(this.plugin);
        menu.item("back", globalItems::back);
        menu.item("previous_page", globalItems::previousPage);
        menu.item("next_page", globalItems::nextPage);
        menu.item("close", globalItems::close);
        menu.fillItem(globalItems::fill);
        SkillItem skillItem = new SkillItem(this.plugin);
        skillItem.buildComponents(menu);
        menu.item("rank", item -> {
            item.replace("rank", p -> {
                Skill skill = (Skill)p.menu().getProperty("skill");
                return String.valueOf(this.getLbRank(skill, p.player()));
            });
            item.replace("total", p -> {
                Skill skill = (Skill)p.menu().getProperty("skill");
                return String.valueOf(this.getLbSize(skill));
            });
            item.replace("percent", p -> {
                Skill skill = (Skill)p.menu().getProperty("skill");
                double percent = this.getLbPercent(skill, p.player());
                return percent > 1.0 ? String.valueOf(Math.round(percent)) : NumberUtil.format2(percent);
            });
            item.replace("skill", p -> ((Skill)p.menu().getProperty("skill")).getDisplayName(p.locale(), false));
            item.onClick(c -> {
                Map<String, Object> properties = c.menu().getProperties();
                properties.put("previous_menu", "level_progression");
                this.plugin.getSlate().openMenu(c.player(), "leaderboard", properties);
            });
        });
        menu.item("sources", item -> item.onClick(c -> {
            BuiltMenu sourcesMenu = this.plugin.getSlate().getBuiltMenu("sources");
            MenuInfo info = new MenuInfo(this.plugin.getSlate(), c.player(), c.menu());
            this.plugin.getSlate().openMenu(c.player(), "sources", sourcesMenu.propertyProvider().get(info));
        }));
        menu.item("abilities", item -> {
            item.onClick(c -> {
                BuiltMenu abilitiesMenu = this.plugin.getSlate().getBuiltMenu("abilities");
                MenuInfo info = new MenuInfo(this.plugin.getSlate(), c.player(), c.menu());
                this.plugin.getSlate().openMenu(c.player(), "abilities", abilitiesMenu.propertyProvider().get(info));
            });
            item.modify(i -> {
                Skill skill = (Skill)i.menu().getProperty("skill");
                boolean hasEnabledAbility = false;
                for (Ability ability : skill.getAbilities()) {
                    if (!ability.isEnabled()) continue;
                    hasEnabledAbility = true;
                    break;
                }
                return hasEnabledAbility ? i.item() : null;
            });
        });
        menu.item("job", item -> {
            item.modify(i -> {
                Skill skill = (Skill)i.menu().getProperty("skill");
                if (this.plugin.config().jobSelectionEnabled() && this.plugin.getUser(i.player()).canSelectJob(skill)) {
                    return i.item();
                }
                return null;
            });
            item.onClick(ClickTrigger.LEFT, c -> {
                User user = this.plugin.getUserManager().getUser(c.player());
                Skill skill = (Skill)c.menu().getProperty("skill");
                if (this.isOnJobSelectCooldown(user)) {
                    return;
                }
                if (!user.getJobs().contains(skill) && user.getJobs().size() < user.getJobLimit()) {
                    user.addJob(skill);
                    c.menu().reload();
                    c.menu().setCooldown("job", 10);
                }
            });
            item.onClick(ClickTrigger.RIGHT, c -> {
                User user = this.plugin.getUserManager().getUser(c.player());
                Skill skill = (Skill)c.menu().getProperty("skill");
                if (user.getJobs().contains(skill)) {
                    user.removeJob(skill);
                    c.menu().reload();
                    c.menu().setCooldown("job", 10);
                }
            });
        });
        menu.component("job_select", null, component -> component.shouldShow(t -> {
            User user = this.plugin.getUser(t.player());
            Skill skill = (Skill)t.menu().getProperty("skill");
            return !user.getJobs().contains(skill) && user.getJobs().size() < user.getJobLimit() && !this.isOnJobSelectCooldown(user);
        }));
        menu.component("job_active", null, component -> component.shouldShow(t -> {
            User user = this.plugin.getUser(t.player());
            Skill skill = (Skill)t.menu().getProperty("skill");
            return user.getJobs().contains(skill);
        }));
        menu.component("job_limit", null, component -> component.shouldShow(t -> {
            User user = this.plugin.getUser(t.player());
            Skill skill = (Skill)t.menu().getProperty("skill");
            return !user.getJobs().contains(skill) && user.getJobs().size() >= user.getJobLimit() && !this.isOnJobSelectCooldown(user);
        }));
        menu.component("job_cooldown", null, component -> {
            component.replace("time", p -> {
                long lastTime = this.plugin.getUser(p.player()).getLastJobSelectTime();
                long cooldown = (long)this.plugin.configInt(Option.JOBS_SELECTION_COOLDOWN_SEC) * 1000L - (System.currentTimeMillis() - lastTime);
                Duration duration = Duration.ofMillis(cooldown);
                long days = duration.toDays();
                long hours = duration.toHoursPart();
                long minutes = duration.toMinutesPart();
                long seconds = duration.toSecondsPart();
                if (days > 0L) {
                    return String.format("%d:%02d:%02d:%02d", days, hours, minutes, seconds);
                }
                return String.format("%02d:%02d:%02d", hours, minutes, seconds);
            });
            component.shouldShow(t -> {
                User user = this.plugin.getUser(t.player());
                Skill skill = (Skill)t.menu().property("skill");
                return !user.getJobs().contains(skill) && this.isOnJobSelectCooldown(user);
            });
        });
        menu.template("skill", Skill.class, template -> {
            skillItem.baseSkillItem((TemplateBuilder<Skill>)template);
            template.definedContexts(m -> Set.of((Skill)m.menu().getProperty("skill")));
        });
        SkillLevelItem levelItem = new SkillLevelItem(this.plugin);
        menu.onOpen(m -> levelItem.loadTrack());
        menu.template("unlocked", Integer.class, template -> {
            template.replace("level", p -> String.valueOf(p.value()));
            template.definedContexts(m -> {
                int level = this.plugin.getUser(m.player()).getSkillLevel((Skill)m.menu().getProperty("skill"));
                int itemsPerPage = levelItem.itemsPerPage(m.menu());
                HashSet<Integer> levels = new HashSet<Integer>();
                for (int i = 0; i < itemsPerPage && levelItem.startLevel(m.menu()) + m.menu().getCurrentPage() * itemsPerPage + i <= level; ++i) {
                    levels.add(levelItem.startLevel(m.menu()) + i + m.menu().getCurrentPage() * itemsPerPage);
                }
                return levels;
            });
            template.slotPos(levelItem::slotPos);
            template.modify(levelItem::modify);
        });
        menu.template("in_progress", Integer.class, template -> {
            template.replace("level", p -> String.valueOf(p.value()));
            template.replace("percent", p -> NumberUtil.format2(this.currentXp(p) / this.xpToNext(p) * 100.0));
            template.replace("current_xp", p -> NumberUtil.format2(this.currentXp(p)));
            template.replace("level_xp", p -> String.valueOf((int)this.xpToNext(p)));
            template.replace("bar", p -> SkillItem.getBar(this.plugin, this.currentXp(p), this.xpToNext(p)));
            template.definedContexts(m -> {
                int itemsPerPage;
                int offset;
                int currentPage = m.menu().getCurrentPage();
                int level = this.plugin.getUser(m.player()).getSkillLevel((Skill)m.menu().getProperty("skill"));
                if (level >= (offset = levelItem.startLevel(m.menu()) - 1) + currentPage * (itemsPerPage = levelItem.itemsPerPage(m.menu())) && level < (currentPage + 1) * itemsPerPage + offset) {
                    return Set.of(Integer.valueOf(level + 1));
                }
                return new HashSet();
            });
            template.slotPos(levelItem::slotPos);
            template.modify(levelItem::modify);
        });
        menu.template("locked", Integer.class, template -> {
            template.replace("level", p -> String.valueOf(p.value()));
            template.definedContexts(m -> {
                int level = this.plugin.getUser(m.player()).getSkillLevel((Skill)m.menu().getProperty("skill"));
                int itemsPerPage = levelItem.itemsPerPage(m.menu());
                HashSet<Integer> levels = new HashSet<Integer>();
                for (int i = itemsPerPage - 1; i >= 0 && levelItem.startLevel(m.menu()) - 1 + m.menu().getCurrentPage() * itemsPerPage + i > level; --i) {
                    levels.add(levelItem.startLevel(m.menu()) + i + m.menu().getCurrentPage() * itemsPerPage);
                }
                return levels;
            });
            template.slotPos(levelItem::slotPos);
            template.modify(levelItem::modify);
        });
        menu.component("rewards", Integer.class, component -> {
            component.replace("entries", this::getRewardEntries);
            component.shouldShow(t -> !this.getRewardsList((Skill)t.menu().getProperty("skill"), (Integer)t.value()).isEmpty());
        });
        menu.component("ability_unlock", Integer.class, component -> {
            component.replace("name", p -> {
                Ability ability = this.unlockedAbility(p);
                return ability.getDisplayName(p.locale(), false);
            });
            component.replace("desc", p -> {
                Ability ability = this.unlockedAbility(p);
                return TextUtil.replace(this.plugin.getAbilityManager().getBaseDescription(ability, this.plugin.getUser(p.player()), false), "{value}", NumberUtil.format1(ability.getValue(1)), "{value_2}", NumberUtil.format1(ability.getSecondaryValue(1)), "{chance_value}", this.plugin.getAbilityManager().getChanceValue(ability, 1), "{guaranteed_value}", this.plugin.getAbilityManager().getGuaranteedValue(ability, 1));
            });
            component.shouldShow(t -> !this.getUnlocked((Skill)t.menu().getProperty("skill"), (Integer)t.value()).isEmpty());
            component.instances(t -> this.getUnlocked((Skill)t.menu().getProperty("skill"), (Integer)t.value()).size());
        });
        menu.component("ability_level", Integer.class, component -> {
            component.replace("name", p -> {
                Ability ability = this.leveledUpAbility(p);
                return ability.getDisplayName(p.locale(), false);
            });
            component.replace("desc", p -> {
                Ability ability = this.leveledUpAbility(p);
                int level = ((Integer)p.value() - ability.getUnlock()) / ability.getLevelUp() + 1;
                return TextUtil.replace(this.plugin.getAbilityManager().getBaseDescription(ability, this.plugin.getUser(p.player()), false), "{value}", NumberUtil.format1(ability.getValue(level)), "{value_2}", NumberUtil.format1(ability.getSecondaryValue(level)), "{chance_value}", this.plugin.getAbilityManager().getChanceValue(ability, level), "{guaranteed_value}", this.plugin.getAbilityManager().getGuaranteedValue(ability, level));
            });
            component.replace("level", p -> {
                Ability ability = this.leveledUpAbility(p);
                int abilityLevel = ((Integer)p.value() - ability.getUnlock()) / ability.getLevelUp() + 1;
                return RomanNumber.toRoman(abilityLevel, this.plugin);
            });
            component.shouldShow(t -> !this.getLeveledUp((Skill)t.menu().getProperty("skill"), (Integer)t.value()).isEmpty());
            component.instances(t -> this.getLeveledUp((Skill)t.menu().getProperty("skill"), (Integer)t.value()).size());
        });
        menu.component("mana_ability_unlock", Integer.class, component -> {
            component.replace("name", p -> {
                ManaAbility manaAbility = ((Skill)p.menu().getProperty("skill")).getManaAbility();
                return manaAbility != null ? manaAbility.getDisplayName(p.locale(), false) : null;
            });
            component.replace("desc", p -> {
                ManaAbility manaAbility = ((Skill)p.menu().getProperty("skill")).getManaAbility();
                if (manaAbility == null) {
                    return null;
                }
                return TextUtil.replace(this.plugin.getManaAbilityManager().getBaseDescription(manaAbility, this.plugin.getUser(p.player()), false), "{value}", NumberUtil.format1(manaAbility.getDisplayValue(1)), "{duration}", NumberUtil.format1(this.getDuration(manaAbility, 1)), "{haste_level}", String.valueOf(ManaAbilities.SPEED_MINE.optionInt("haste_level", 10)));
            });
            component.shouldShow(t -> {
                ManaAbility manaAbility = ((Skill)t.menu().getProperty("skill")).getManaAbility();
                if (manaAbility != null && manaAbility.isEnabled()) {
                    return manaAbility.getUnlock() == ((Integer)t.value()).intValue();
                }
                return false;
            });
        });
        menu.component("mana_ability_level", Integer.class, component -> {
            component.replace("name", p -> {
                ManaAbility manaAbility = ((Skill)p.menu().getProperty("skill")).getManaAbility();
                return manaAbility != null ? manaAbility.getDisplayName(p.locale(), false) : null;
            });
            component.replace("desc", p -> {
                ManaAbility manaAbility = ((Skill)p.menu().getProperty("skill")).getManaAbility();
                if (manaAbility == null) {
                    return null;
                }
                int manaAbilityLevel = ((Integer)p.value() - manaAbility.getUnlock()) / manaAbility.getLevelUp() + 1;
                return TextUtil.replace(this.plugin.getManaAbilityManager().getBaseDescription(manaAbility, this.plugin.getUser(p.player()), false), "{value}", NumberUtil.format1(manaAbility.getDisplayValue(manaAbilityLevel)), "{duration}", NumberUtil.format1(this.getDuration(manaAbility, manaAbilityLevel)), "{haste_level}", String.valueOf(ManaAbilities.SPEED_MINE.optionInt("haste_level", 10)));
            });
            component.replace("level", p -> {
                ManaAbility manaAbility = ((Skill)p.menu().getProperty("skill")).getManaAbility();
                if (manaAbility == null) {
                    return null;
                }
                int manaAbilityLevel = ((Integer)p.value() - manaAbility.getUnlock()) / manaAbility.getLevelUp() + 1;
                return RomanNumber.toRoman(manaAbilityLevel, this.plugin);
            });
            component.shouldShow(t -> {
                Skill skill = (Skill)t.menu().getProperty("skill");
                ManaAbility manaAbility = skill.getManaAbility();
                if (manaAbility != null && manaAbility.isEnabled()) {
                    return this.plugin.getManaAbilityManager().getManaAbilityAtLevel(skill, (Integer)t.value()) != null && manaAbility.getUnlock() != ((Integer)t.value()).intValue();
                }
                return false;
            });
        });
    }

    private boolean isOnJobSelectCooldown(User user) {
        int selectionCooldown = this.plugin.configInt(Option.JOBS_SELECTION_COOLDOWN_SEC);
        if (selectionCooldown > 0) {
            long lastTime = user.getLastJobSelectTime();
            return lastTime + (long)selectionCooldown * 1000L > System.currentTimeMillis();
        }
        return false;
    }

    private double getDuration(ManaAbility manaAbility, int level) {
        return AbilityUtil.getDuration(manaAbility, level);
    }

    private Ability leveledUpAbility(ComponentPlaceholderInfo<Integer> p) {
        return this.getLeveledUp((Skill)p.menu().getProperty("skill"), (Integer)p.value()).get(p.component().instance());
    }

    private List<Ability> getLeveledUp(Skill skill, int level) {
        return this.plugin.getAbilityManager().getAbilities(skill, level).stream().filter(a -> a.getUnlock() != level).filter(Ability::isEnabled).toList();
    }

    private Ability unlockedAbility(ComponentPlaceholderInfo<Integer> p) {
        return this.getUnlocked((Skill)p.menu().getProperty("skill"), (Integer)p.value()).get(p.component().instance());
    }

    private List<Ability> getUnlocked(Skill skill, int level) {
        return this.plugin.getAbilityManager().getAbilities(skill, level).stream().filter(a -> a.getUnlock() == level).filter(Ability::isEnabled).toList();
    }

    private ImmutableList<SkillReward> getRewardsList(Skill skill, int level) {
        return this.plugin.getRewardManager().getRewardTable(skill).getRewards(level);
    }

    private String getRewardEntries(TemplatePlaceholderInfo<Integer> info) {
        Skill skill = (Skill)info.menu().getProperty("skill");
        int level = info.value();
        ImmutableList<SkillReward> rewards = this.getRewardsList(skill, level);
        StringBuilder message = new StringBuilder();
        double totalMoney = 0.0;
        for (SkillReward reward : rewards) {
            String rewardMsg = reward.getMenuMessage(this.plugin.getUser(info.player()), info.locale(), skill, level);
            if (rewardMsg != null) {
                message.append(rewardMsg);
            }
            if (!(reward instanceof MoneyReward)) continue;
            totalMoney += ((MoneyReward)reward).getAmount(level);
        }
        if (totalMoney > 0.0) {
            message.append(TextUtil.replace(info.menu().getFormat("money_reward_entry"), "{amount}", NumberUtil.format2(totalMoney)));
        }
        return message.toString();
    }

    private double currentXp(TemplatePlaceholderInfo<Integer> p) {
        Skill skill = (Skill)p.menu().getProperty("skill");
        return this.plugin.getUser(p.player()).getSkillXp(skill);
    }

    private double xpToNext(TemplatePlaceholderInfo<Integer> p) {
        Skill skill = (Skill)p.menu().getProperty("skill");
        return this.plugin.getXpRequirements().getXpRequired(skill, p.value());
    }

    private double getLbPercent(Skill skill, Player player) {
        int rank = this.getLbRank(skill, player);
        int size = this.getLbSize(skill);
        if (size == 0) {
            size = 1;
        }
        return (double)rank / (double)size * 100.0;
    }

    private int getLbRank(Skill skill, Player player) {
        return this.plugin.getLeaderboardManager().getSkillRank(skill, player.getUniqueId());
    }

    private int getLbSize(Skill skill) {
        return this.plugin.getLeaderboardManager().getLeaderboard(skill).size();
    }
}

