/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.loot.parser;

import dev.aurelium.auraskills.api.config.ConfigNode;
import dev.aurelium.auraskills.api.loot.Loot;
import dev.aurelium.auraskills.api.loot.LootParser;
import dev.aurelium.auraskills.api.loot.LootParsingContext;
import dev.aurelium.auraskills.api.loot.LootRequirements;
import dev.aurelium.auraskills.bukkit.loot.BukkitLootManager;
import dev.aurelium.auraskills.bukkit.loot.item.enchant.LootEnchantLevel;
import dev.aurelium.auraskills.bukkit.loot.type.ItemLoot;
import dev.aurelium.auraskills.bukkit.ref.BukkitItemRef;
import dev.aurelium.auraskills.bukkit.util.ConfigurateItemParser;
import dev.aurelium.auraskills.common.api.implementation.ApiConfigNode;
import dev.aurelium.auraskills.common.loot.CustomItemParser;
import dev.aurelium.auraskills.common.loot.ItemSupplier;
import dev.aurelium.auraskills.common.loot.enchant.LootEnchantEntry;
import dev.aurelium.auraskills.common.loot.enchant.LootEnchantList;
import dev.aurelium.auraskills.common.loot.enchant.LootEnchantments;
import dev.aurelium.auraskills.common.util.data.Validate;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.configurate.serialize.SerializationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.inventory.ItemStack;

public class ItemLootParser
implements LootParser {
    private final BukkitLootManager manager;
    private final ConfigurateItemParser itemParser;

    public ItemLootParser(BukkitLootManager manager) {
        this.manager = manager;
        this.itemParser = new ConfigurateItemParser(manager.getPlugin());
    }

    @Override
    public Loot parse(LootParsingContext context, ConfigNode config, LootRequirements requirements) {
        ItemSupplier item = null;
        ConfigurationNode backing = ((ApiConfigNode)config).getBacking();
        for (CustomItemParser parser : this.manager.getCustomItemParsers()) {
            if (!parser.shouldUseParser(backing)) continue;
            item = parser.parseCustomItem(backing);
            break;
        }
        if (item == null) {
            try {
                item = this.parseItem(backing);
            }
            catch (SerializationException e) {
                throw new RuntimeException(e);
            }
        }
        Validate.notNull(item, "Failed to parse item");
        int[] amounts = this.parseAmount(backing);
        double[] durability = this.parseDurability(backing);
        return new ItemLoot(context.parseValues(config, requirements), item, amounts[0], amounts[1], durability[0], durability[1]);
    }

    private ItemSupplier parseItem(ConfigurationNode config) throws SerializationException {
        List<String> excludedKeys = List.of("amount", "enchantments");
        ItemStack baseItem = this.itemParser.parseItem(config, excludedKeys);
        Map<LootEnchantList, Integer> possibleEnchants = this.parsePossibleEnchants(config);
        return new ItemSupplier(BukkitItemRef.wrap(baseItem), null, new LootEnchantments(possibleEnchants));
    }

    private Map<LootEnchantList, Integer> parsePossibleEnchants(ConfigurationNode config) {
        HashMap<LootEnchantList, Integer> possibleEnchants = new HashMap<LootEnchantList, Integer>();
        if (config.hasChild("enchantments")) {
            LootEnchantList singleList = this.parseSingleEnchantList(config);
            possibleEnchants.put(singleList, 1);
        }
        return Map.copyOf(possibleEnchants);
    }

    private LootEnchantList parseSingleEnchantList(ConfigurationNode config) {
        ArrayList<LootEnchantEntry> entryList = new ArrayList<LootEnchantEntry>();
        for (ConfigurationNode configurationNode : config.node("enchantments").childrenList()) {
            String enchantmentName;
            String levelString = "1";
            double chance = 1.0;
            if (configurationNode.isMap()) {
                enchantmentName = configurationNode.node("name").getString("").toLowerCase(Locale.ROOT);
                levelString = configurationNode.node("level").getString("1");
                chance = Double.parseDouble(configurationNode.node("chance").getString("1.0"));
            } else {
                String[] splitEntry = configurationNode.getString("").split(" ");
                enchantmentName = splitEntry[0].toLowerCase(Locale.ROOT);
                if (splitEntry.length > 1) {
                    levelString = splitEntry[1];
                }
            }
            LootEnchantLevel enchantLevel = this.parseLevel(levelString);
            LootEnchantEntry entry = new LootEnchantEntry(enchantmentName, enchantLevel.minLevel(), enchantLevel.maxLevel(), chance);
            entryList.add(entry);
        }
        return new LootEnchantList(entryList);
    }

    protected LootEnchantLevel parseLevel(String levelString) {
        int maxLevel;
        int minLevel;
        if (levelString.contains("-")) {
            String[] splitLevel = levelString.split("-");
            minLevel = Integer.parseInt(splitLevel[0]);
            maxLevel = Integer.parseInt(splitLevel[1]);
        } else {
            int fixedLevel;
            minLevel = fixedLevel = Integer.parseInt(levelString);
            maxLevel = fixedLevel;
        }
        return new LootEnchantLevel(minLevel, maxLevel);
    }

    protected int[] parseAmount(ConfigurationNode config) {
        if (config.hasChild("amount")) {
            Object object = config.node("amount").raw();
            if (object instanceof Integer) {
                Integer amount = (Integer)object;
                return new int[]{amount, amount};
            }
            if (object instanceof String) {
                int minAmount;
                String amountString = (String)object;
                String[] splitString = amountString.split("-");
                int maxAmount = minAmount = Integer.parseInt(splitString[0]);
                if (splitString.length > 1) {
                    maxAmount = Integer.parseInt(splitString[1]);
                }
                return new int[]{minAmount, maxAmount};
            }
        }
        return new int[]{1, 1};
    }

    protected double[] parseDurability(ConfigurationNode config) {
        double minDamage = 0.0;
        double maxDamage = 0.0;
        if (config.hasChild("damage")) {
            if (config.node("damage").isMap()) {
                minDamage = config.node("damage", "min").getDouble();
                maxDamage = config.node("damage", "max").getDouble();
            } else {
                maxDamage = minDamage = config.node("damage").getDouble();
            }
        }
        return new double[]{minDamage, maxDamage};
    }
}

