/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.loot.item.enchant;

import dev.aurelium.auraskills.api.loot.LootTable;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.loot.item.enchant.LeveledEnchant;
import dev.aurelium.auraskills.bukkit.ref.BukkitItemRef;
import dev.aurelium.auraskills.common.loot.enchant.LootEnchantEntry;
import dev.aurelium.auraskills.common.loot.enchant.LootEnchantList;
import dev.aurelium.auraskills.common.loot.enchant.LootEnchantments;
import dev.aurelium.auraskills.common.ref.ItemRef;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Nullable;

public class BukkitLootEnchantments {
    private final LootEnchantments lootEnchantments;

    public BukkitLootEnchantments(LootEnchantments lootEnchantments) {
        this.lootEnchantments = lootEnchantments;
    }

    public void applyEnchantments(ItemRef ref, AuraSkills plugin, LootTable table) {
        ItemStack item = BukkitItemRef.unwrap(ref);
        LootEnchantList list = this.selectEnchantList();
        if (list == null) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        List<LeveledEnchant> enchants = this.rollEnchants(plugin, table, list);
        for (LeveledEnchant enchant : enchants) {
            if (meta instanceof EnchantmentStorageMeta) {
                EnchantmentStorageMeta esm = (EnchantmentStorageMeta)meta;
                esm.addStoredEnchant(enchant.enchant(), enchant.level(), true);
                continue;
            }
            meta.addEnchant(enchant.enchant(), enchant.level(), true);
        }
        item.setItemMeta(meta);
    }

    public List<LeveledEnchant> rollEnchants(AuraSkills plugin, LootTable table, LootEnchantList list) {
        ArrayList<LeveledEnchant> rolled = new ArrayList<LeveledEnchant>();
        for (LootEnchantEntry entry : list.entries()) {
            Enchantment enchantment = (Enchantment)Registry.ENCHANTMENT.get(NamespacedKey.minecraft((String)entry.enchantName().toLowerCase(Locale.ROOT)));
            double chance = 1.0;
            if (entry.chance() < 1.0) {
                chance = ThreadLocalRandom.current().nextDouble(0.0, 1.0);
            }
            if (enchantment != null) {
                if (!(chance <= entry.chance())) continue;
                int rolledLevel = ThreadLocalRandom.current().nextInt(entry.minLevel(), entry.maxLevel() + 1);
                rolled.add(new LeveledEnchant(enchantment, rolledLevel));
                continue;
            }
            plugin.logger().warn("Error while rolling enchant in loot table " + String.valueOf(table.getId()) + ": Could not find enchantment in Minecraft registry with key " + entry.enchantName());
        }
        return rolled;
    }

    @Nullable
    private LootEnchantList selectEnchantList() {
        if (this.lootEnchantments.possibleEnchants().isEmpty()) {
            return null;
        }
        int totalWeight = this.lootEnchantments.possibleEnchants().values().stream().reduce(Integer::sum).orElse(0);
        if (totalWeight == 0) {
            return null;
        }
        Random random = new Random();
        int selected = random.nextInt(totalWeight);
        int currentWeight = 0;
        LootEnchantList selectedList = null;
        for (LootEnchantList list : this.lootEnchantments.possibleEnchants().keySet()) {
            int listWeight = this.lootEnchantments.possibleEnchants().getOrDefault(list, 0);
            if (selected >= currentWeight && selected < currentWeight + listWeight) {
                selectedList = list;
                break;
            }
            currentWeight += listWeight;
        }
        return selectedList;
    }
}

