/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.loot.item;

import dev.aurelium.auraskills.api.loot.LootTable;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.loot.item.enchant.BukkitLootEnchantments;
import dev.aurelium.auraskills.bukkit.ref.BukkitItemRef;
import dev.aurelium.auraskills.common.loot.ItemSupplier;
import dev.aurelium.auraskills.common.ref.ItemRef;
import org.jetbrains.annotations.Nullable;

public class BukkitItemSupplier {
    private final ItemSupplier supplier;

    public BukkitItemSupplier(ItemSupplier supplier) {
        this.supplier = supplier;
    }

    @Nullable
    public ItemRef supplyItem(AuraSkills plugin, LootTable table) {
        ItemRef baseItem = this.supplier.baseItem();
        ItemRef item = null;
        if (baseItem != null) {
            item = this.supplier.baseItem().clone();
        }
        if (this.supplier.baseItemKey() != null) {
            item = BukkitItemRef.wrap(plugin.getItemRegistry().getItem(this.supplier.baseItemKey()));
        }
        if (this.supplier.enchantments() != null) {
            new BukkitLootEnchantments(this.supplier.enchantments()).applyEnchantments(item, plugin, table);
        }
        return item;
    }
}

