/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.loot.entity;

import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.loot.entity.EntityProperties;
import dev.aurelium.auraskills.bukkit.loot.entity.EntitySupplier;
import dev.aurelium.auraskills.bukkit.util.AttributeCompat;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class VanillaEntitySupplier
extends EntitySupplier {
    public VanillaEntitySupplier(EntityProperties entityProperties) {
        super(entityProperties);
    }

    @Override
    public Entity spawnEntity(AuraSkills plugin, Location location) {
        World world = location.getWorld();
        if (world == null) {
            return null;
        }
        EntityProperties properties = this.getEntityProperties();
        Entity entity = world.spawnEntity(location, EntityType.valueOf((String)properties.entityId().toUpperCase()));
        if (entity instanceof LivingEntity) {
            EntityEquipment equipment;
            AttributeInstance attribute;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.getEntityProperties().health() != null && (attribute = livingEntity.getAttribute(AttributeCompat.maxHealth)) != null) {
                attribute.setBaseValue(this.getEntityProperties().health().doubleValue());
                livingEntity.setHealth(Math.min(this.getEntityProperties().health(), attribute.getValue()));
            }
            if (properties.damage() != null && (attribute = livingEntity.getAttribute(AttributeCompat.attackDamage)) != null) {
                attribute.setBaseValue(this.getEntityProperties().damage().doubleValue());
            }
            if ((equipment = livingEntity.getEquipment()) != null) {
                for (Map.Entry<EquipmentSlot, ItemStack> entry : properties.equipment().entrySet()) {
                    EquipmentSlot slot = entry.getKey();
                    ItemStack item = entry.getValue();
                    equipment.setItem(slot, item, true);
                }
            }
        }
        if (properties.name() != null) {
            entity.setCustomName(plugin.getMessageProvider().applyFormatting(this.getEntityProperties().name()));
            entity.setCustomNameVisible(true);
        }
        if (properties.level() != null) {
            entity.setMetadata("auraskills_level", (MetadataValue)new FixedMetadataValue((Plugin)plugin, (Object)this.getEntityProperties().level()));
        }
        return entity;
    }

    @Override
    public void removeEntity(Entity entity) {
        entity.remove();
    }
}

