/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.listeners;

import dev.aurelium.auraskills.api.source.SkillSource;
import dev.aurelium.auraskills.api.source.type.BlockXpSource;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.source.BlockLeveler;
import java.util.Set;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.CauldronLevelChangeEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class BlockInteractions
implements Listener {
    private final AuraSkills plugin;
    private final Set<CauldronLevelChangeEvent.ChangeReason> cauldronLevelChangeReasons = Set.of(CauldronLevelChangeEvent.ChangeReason.BOTTLE_EMPTY, CauldronLevelChangeEvent.ChangeReason.BUCKET_EMPTY);

    public BlockInteractions(AuraSkills plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlockFertilize(BlockFertilizeEvent event) {
        Block block = event.getBlock();
        SkillSource<BlockXpSource> skillSource = this.plugin.getLevelManager().getLeveler(BlockLeveler.class).getSourceByMaterialOnly(block);
        if (skillSource == null) {
            return;
        }
        BlockXpSource source = skillSource.source();
        if (source.allowBoneMeal()) {
            return;
        }
        block.setMetadata("fertilized", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
    }

    @EventHandler
    public void onCauldronFill(CauldronLevelChangeEvent event) {
        CauldronLevelChangeEvent.ChangeReason reason = event.getReason();
        if (this.cauldronLevelChangeReasons.contains(reason)) {
            Block cauldron = event.getBlock();
            cauldron.setMetadata("filledManually", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
        }
    }
}

