/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.level;

import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.common.config.ConfigurateLoader;
import dev.aurelium.auraskills.common.level.XpRequirements;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.configurate.serialize.SerializationException;
import dev.aurelium.auraskills.configurate.serialize.TypeSerializerCollection;
import dev.aurelium.auraskills.evalex.EvaluationException;
import dev.aurelium.auraskills.evalex.Expression;
import dev.aurelium.auraskills.evalex.parser.ParseException;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class XpRequirementsLoader {
    private final AuraSkills plugin;
    private final XpRequirements requirements;

    public XpRequirementsLoader(AuraSkills plugin, XpRequirements requirements) {
        this.plugin = plugin;
        this.requirements = requirements;
    }

    public void load() {
        ConfigurateLoader loader = new ConfigurateLoader(this.plugin, TypeSerializerCollection.builder().build());
        String fileName = "xp_requirements.yml";
        try {
            loader.generateUserFile(fileName);
            ConfigurationNode config = loader.loadUserFile(fileName);
            ConfigurationNode defaultConfig = config.node("default");
            if (!defaultConfig.virtual()) {
                try {
                    this.requirements.setDefaultXpRequirements(this.loadSection(defaultConfig));
                }
                catch (EvaluationException | ParseException e) {
                    this.plugin.logger().warn("Failed to evaluate default XP requirements expression");
                    e.printStackTrace();
                }
            }
            for (Skill skill : this.plugin.getSkillManager().getSkillValues()) {
                this.requirements.removeSkillXpRequirements(skill);
                ConfigurationNode skillNode = config.node("skills").node(skill.name().toLowerCase());
                if (skillNode.virtual()) {
                    skillNode = config.node("skills").node(skill.getId().toString());
                }
                if (skillNode.virtual()) continue;
                try {
                    this.requirements.setSkillXpRequirements(skill, this.loadSection(skillNode));
                }
                catch (EvaluationException | ParseException e) {
                    this.plugin.logger().warn("Failed to evaluate XP requirement expression for skill " + String.valueOf(skill));
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            this.plugin.logger().warn("Failed to load " + fileName + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    private List<Integer> loadSection(ConfigurationNode config) throws SerializationException, EvaluationException, ParseException {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int highestMaxLevel = this.plugin.config().getHighestMaxLevel();
        if (!config.node("values").virtual()) {
            List<String> values = config.node("values").getList(String.class);
            Objects.requireNonNull(values);
            for (int i = 0; i < highestMaxLevel; ++i) {
                if (i < values.size()) {
                    list.add(Integer.parseInt(values.get(i)));
                    continue;
                }
                list.add(Integer.parseInt(values.get(values.size() - 1)));
            }
        } else {
            Expression expression = this.getXpExpression(config);
            for (int i = 0; i < highestMaxLevel; ++i) {
                expression.with("level", BigDecimal.valueOf(i + 2));
                list.add((int)Math.round(expression.evaluate().getNumberValue().doubleValue()));
            }
        }
        return list;
    }

    private Expression getXpExpression(ConfigurationNode config) {
        String expressionString = config.node("expression").getString();
        Objects.requireNonNull(expressionString);
        Expression expression = new Expression(expressionString);
        for (Object variableObj : config.childrenMap().keySet()) {
            String variable = (String)variableObj;
            if (variable.equals("expression")) continue;
            double variableValue = config.node(variable).getDouble();
            expression.with(variable, BigDecimal.valueOf(variableValue));
        }
        return expression;
    }
}

