/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.item;

import dev.aurelium.auraskills.api.item.ModifierType;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.api.util.AuraSkillsModifier;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.util.ItemUtils;
import dev.aurelium.auraskills.nbtapi.iface.ReadWriteNBT;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class Modifiers {
    private final AuraSkills plugin;

    public Modifiers(AuraSkills plugin) {
        this.plugin = plugin;
    }

    public List<StatModifier> getLegacyModifiers(ModifierType type, ReadWriteNBT nbt) {
        if (this.plugin.isNbtApiDisabled()) {
            return new ArrayList<StatModifier>();
        }
        ArrayList<StatModifier> modifiers = new ArrayList<StatModifier>();
        ReadWriteNBT compound = ItemUtils.getLegacyModifiersTypeCompound(nbt, type);
        for (String key : compound.getKeys()) {
            Stat stat = (Stat)this.plugin.getStatRegistry().getOrNull(NamespacedId.fromDefault(key.toLowerCase(Locale.ROOT)));
            if (stat == null) continue;
            double value = compound.getDouble(key);
            modifiers.add(new StatModifier(key, stat, value, AuraSkillsModifier.Operation.ADD));
        }
        return modifiers;
    }
}

