/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.item;

import com.google.common.collect.Sets;
import dev.aurelium.auraskills.api.item.ItemCategory;
import dev.aurelium.auraskills.api.item.ItemFilter;
import dev.aurelium.auraskills.api.item.ItemFilterMeta;
import dev.aurelium.auraskills.api.item.LootItemFilter;
import dev.aurelium.auraskills.api.item.PotionData;
import dev.aurelium.auraskills.api.loot.Loot;
import dev.aurelium.auraskills.api.loot.LootPool;
import dev.aurelium.auraskills.api.loot.LootTable;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.item.BukkitPotionType;
import dev.aurelium.auraskills.bukkit.item.BukkitSourceMenuItems;
import dev.aurelium.auraskills.bukkit.item.ExternalItemProvider;
import dev.aurelium.auraskills.bukkit.item.ItemRegistryStorage;
import dev.aurelium.auraskills.bukkit.loot.item.BukkitItemSupplier;
import dev.aurelium.auraskills.bukkit.loot.type.ItemLoot;
import dev.aurelium.auraskills.bukkit.ref.BukkitItemRef;
import dev.aurelium.auraskills.bukkit.user.BukkitUser;
import dev.aurelium.auraskills.bukkit.util.ItemUtils;
import dev.aurelium.auraskills.bukkit.util.PotionUtil;
import dev.aurelium.auraskills.common.item.ItemRegistry;
import dev.aurelium.auraskills.common.item.SourceItem;
import dev.aurelium.auraskills.common.message.type.LevelerMessage;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.data.KeyIntPair;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.Nullable;

public class BukkitItemRegistry
implements ItemRegistry {
    private final AuraSkills plugin;
    private final Map<NamespacedId, ItemStack> items = new ConcurrentHashMap<NamespacedId, ItemStack>();
    private final BukkitSourceMenuItems sourceMenuItems;
    private final ItemRegistryStorage storage;
    private final Map<String, ExternalItemProvider> externalItemProviders = new ConcurrentHashMap<String, ExternalItemProvider>();
    private final Map<NamespacedId, Consumer<ItemStack>> unresolvedExternalItems = new ConcurrentHashMap<NamespacedId, Consumer<ItemStack>>();

    public BukkitItemRegistry(AuraSkills plugin) {
        this.plugin = plugin;
        this.sourceMenuItems = new BukkitSourceMenuItems(plugin);
        this.storage = new ItemRegistryStorage(plugin, this);
    }

    public void register(NamespacedId key, ItemStack item) {
        this.items.put(key, item.clone());
    }

    public void unregister(NamespacedId key) {
        this.items.remove(key);
    }

    public Set<NamespacedId> getIds() {
        return this.items.keySet();
    }

    public void reloadUnresolvedItems(String namespace) {
        this.unresolvedExternalItems.entrySet().removeIf(entry -> {
            if (!((NamespacedId)entry.getKey()).getNamespace().equals(namespace)) {
                return false;
            }
            ItemStack reloaded = this.getItem((NamespacedId)entry.getKey());
            if (reloaded != null) {
                ((Consumer)entry.getValue()).accept(reloaded);
                return true;
            }
            return false;
        });
    }

    @Nullable
    public ItemStack getItem(NamespacedId key) {
        return this.getItem(key, null);
    }

    @Nullable
    public ItemStack getItem(NamespacedId key, @Nullable Consumer<ItemStack> unresolvedConsumer) {
        ItemStack item = this.items.get(key);
        if (item != null) {
            return item;
        }
        ExternalItemProvider provider = this.externalItemProviders.get(key.getNamespace());
        if (provider != null) {
            ItemStack external = provider.getItem(key.getOriginalKey());
            if (external != null) {
                return external.clone();
            }
            if (unresolvedConsumer != null) {
                this.unresolvedExternalItems.put(key, unresolvedConsumer);
            }
        }
        return null;
    }

    public Map<NamespacedId, ItemStack> getItems() {
        return this.items;
    }

    @Override
    public boolean containsItem(NamespacedId key) {
        return this.items.containsKey(key);
    }

    @Override
    public void giveItem(User user, NamespacedId key, int amount) {
        Player player = ((BukkitUser)user).getPlayer();
        if (player == null) {
            return;
        }
        ItemStack item = this.getItem(key);
        if (item == null) {
            return;
        }
        this.plugin.getScheduler().executeAtEntity((Entity)player, task -> {
            item.setAmount(amount);
            ItemStack leftoverItem = ItemUtils.addItemToInventory(player, item);
            if (leftoverItem != null) {
                user.getUnclaimedItems().add(new KeyIntPair(key.toString(), leftoverItem.getAmount()));
                this.plugin.getScheduler().executeSync(() -> player.sendMessage(this.plugin.getPrefix(user.getLocale()) + this.plugin.getMsg(LevelerMessage.UNCLAIMED_ITEM, user.getLocale())));
            }
        });
    }

    @Override
    public int getItemAmount(NamespacedId key) {
        ItemStack item = this.getItem(key);
        if (item == null) {
            return 1;
        }
        return item.getAmount();
    }

    @Override
    @Nullable
    public String getEffectiveItemName(NamespacedId key) {
        ItemStack item = this.getItem(key);
        if (item == null) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (meta.hasDisplayName()) {
                return meta.getDisplayName();
            }
            return item.getType().name().toLowerCase(Locale.ROOT).replace("_", " ");
        }
        return null;
    }

    public BukkitSourceMenuItems getSourceMenuItems() {
        return this.sourceMenuItems;
    }

    public boolean passesFilter(ItemStack item, LootItemFilter filter, Skill skill) {
        String lootPoolName = filter.lootPool();
        if (lootPoolName != null) {
            LootTable lootTable = this.plugin.getLootManager().getLootTable(skill);
            if (lootTable == null) {
                return false;
            }
            LootPool pool = lootTable.getPool(lootPoolName);
            if (pool == null) {
                return false;
            }
            for (Loot loot : pool.getLoot()) {
                ItemLoot itemLoot;
                BukkitItemSupplier bukkitItemSupplier;
                if (!(loot instanceof ItemLoot) || !item.equals((Object)BukkitItemRef.unwrap((bukkitItemSupplier = new BukkitItemSupplier((itemLoot = (ItemLoot)loot).getItem())).supplyItem(this.plugin, lootTable)))) continue;
                return true;
            }
            return false;
        }
        SourceItem itemFilter = new SourceItem(filter.materials(), filter.excludedMaterials(), filter.category(), filter.meta());
        return this.passesFilter(item, itemFilter);
    }

    public boolean passesFilter(ItemStack item, ItemFilter filter) {
        ItemCategory category;
        if (item == null) {
            return false;
        }
        String[] materials = filter.materials();
        if (materials != null && !TextUtil.contains(materials, item.getType().toString())) {
            return false;
        }
        String[] excludedMaterials = filter.excludedMaterials();
        if (excludedMaterials != null) {
            for (String excludedMaterial : excludedMaterials) {
                if (!excludedMaterial.toUpperCase(Locale.ROOT).equals(item.getType().toString())) continue;
                return false;
            }
        }
        if ((category = filter.category()) != null && !this.getItemCategories(item, item.getType()).contains((Object)category)) {
            return false;
        }
        return this.passesItemMetaFilter(item, filter);
    }

    public ItemRegistryStorage getStorage() {
        return this.storage;
    }

    public void registerExternalItemProvider(String namespace, ExternalItemProvider provider) {
        this.externalItemProviders.put(namespace, provider);
    }

    private boolean passesItemMetaFilter(ItemStack item, ItemFilter filter) {
        ItemFilterMeta filterMeta = filter.meta();
        if (filterMeta == null) {
            return true;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return true;
        }
        if (!filterMeta.ignoreCustomModelData()) {
            if (filterMeta.hasCustomModelData()) {
                if (!itemMeta.hasCustomModelData()) {
                    return false;
                }
                if (itemMeta.getCustomModelData() != filterMeta.customModelData()) {
                    return false;
                }
            } else if (itemMeta.hasCustomModelData()) {
                return false;
            }
        }
        if (filterMeta.displayName() != null && !itemMeta.getDisplayName().equals(filterMeta.displayName())) {
            return false;
        }
        List<String> filterLore = filterMeta.lore();
        if (filterLore != null && !filterLore.isEmpty() && !filterLore.equals(itemMeta.getLore())) {
            return false;
        }
        PotionData potionData = filterMeta.potionData();
        if (potionData != null) {
            if (!(itemMeta instanceof PotionMeta)) {
                return false;
            }
            PotionMeta potionMeta = (PotionMeta)itemMeta;
            String[] types = potionData.types();
            BukkitPotionType bukkitPotionType = new BukkitPotionType(potionMeta);
            PotionType basePotionType = bukkitPotionType.getType();
            if (types != null && basePotionType != null && !TextUtil.contains(types, basePotionType.toString())) {
                return false;
            }
            String[] excludedTypes = potionData.excludedTypes();
            if (excludedTypes != null && basePotionType != null && TextUtil.contains(excludedTypes, basePotionType.toString())) {
                return false;
            }
            if (potionData.extended() != bukkitPotionType.isExtended()) {
                return false;
            }
            if (potionData.upgraded() != bukkitPotionType.isUpgraded()) {
                return false;
            }
            if (potionData.excludeNegative()) {
                return basePotionType == null || !PotionUtil.isNegativePotion(basePotionType);
            }
            return true;
        }
        return true;
    }

    private Set<ItemCategory> getItemCategories(ItemStack item, Material mat) {
        Set found = Sets.newConcurrentHashSet();
        String name = mat.toString();
        if (name.contains("_SWORD") || mat == Material.BOW || mat == Material.CROSSBOW || mat == Material.TRIDENT) {
            found.add(ItemCategory.WEAPON);
        } else if (name.contains("_HELMET") || name.contains("_CHESTPLATE") || name.contains("_LEGGINGS") || name.contains("_BOOTS") || mat == Material.ELYTRA) {
            found.add(ItemCategory.ARMOR);
        } else if (name.contains("_PICKAXE") || name.contains("_AXE") || name.contains("_SHOVEL") || name.contains("_HOE") || mat == Material.SHEARS || mat == Material.FISHING_ROD || mat == Material.FLINT_AND_STEEL) {
            found.add(ItemCategory.TOOL);
        }
        if (mat == Material.LILY_PAD || mat == Material.BOWL || mat == Material.LEATHER || mat == Material.LEATHER_BOOTS || mat == Material.ROTTEN_FLESH || mat == Material.STICK || mat == Material.STRING || mat == Material.BONE || mat == Material.INK_SAC || mat == Material.TRIPWIRE_HOOK) {
            found.add(ItemCategory.FISHING_JUNK);
        }
        if (mat == Material.FISHING_ROD) {
            if (item.getEnchantments().isEmpty()) {
                found.add(ItemCategory.FISHING_JUNK);
            } else {
                found.add(ItemCategory.FISHING_TREASURE);
            }
        }
        if (mat == Material.POTION && item.getItemMeta() instanceof PotionMeta) {
            found.add(ItemCategory.FISHING_JUNK);
        }
        if (mat == Material.BOW || mat == Material.ENCHANTED_BOOK || mat == Material.NAME_TAG || mat == Material.NAUTILUS_SHELL || mat == Material.SADDLE) {
            found.add(ItemCategory.FISHING_TREASURE);
        }
        return found;
    }
}

