/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.item;

import dev.aurelium.auraskills.api.config.ConfigNode;
import dev.aurelium.auraskills.api.item.ItemFilter;
import dev.aurelium.auraskills.api.item.ItemManager;
import dev.aurelium.auraskills.api.item.ModifierType;
import dev.aurelium.auraskills.api.skill.Multiplier;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.TraitModifier;
import dev.aurelium.auraskills.api.util.AuraSkillsModifier;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.item.SkillsItem;
import dev.aurelium.auraskills.bukkit.util.ConfigurateItemParser;
import dev.aurelium.auraskills.common.api.implementation.ApiConfigNode;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.configurate.serialize.SerializationException;
import java.util.List;
import java.util.Map;
import org.bukkit.inventory.ItemStack;

public class ApiItemManager
implements ItemManager {
    private final AuraSkills plugin;
    private final ConfigurateItemParser itemParser;

    public ApiItemManager(AuraSkills plugin) {
        this.plugin = plugin;
        this.itemParser = new ConfigurateItemParser(plugin);
    }

    @Override
    public ItemStack addStatModifier(ItemStack item, ModifierType type, Stat stat, double value, AuraSkillsModifier.Operation operation, boolean lore) {
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        skillsItem.addModifier(SkillsItem.MetaType.MODIFIER, type, stat, value, operation);
        if (lore) {
            skillsItem.addModifierLore(type, stat, value, operation, this.plugin.getDefaultLanguage());
        }
        return skillsItem.getItem();
    }

    @Override
    public ItemStack addStatModifier(ItemStack item, ModifierType type, Stat stat, double value, boolean lore) {
        return this.addStatModifier(item, type, stat, value, AuraSkillsModifier.Operation.ADD, lore);
    }

    @Override
    public ItemStack addTraitModifier(ItemStack item, ModifierType type, Trait trait, double value, AuraSkillsModifier.Operation operation, boolean lore) {
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        skillsItem.addModifier(SkillsItem.MetaType.TRAIT_MODIFIER, type, trait, value, operation);
        if (lore) {
            skillsItem.addModifierLore(type, trait, value, operation, this.plugin.getDefaultLanguage());
        }
        return skillsItem.getItem();
    }

    @Override
    public ItemStack addTraitModifier(ItemStack item, ModifierType type, Trait trait, double value, boolean lore) {
        return this.addTraitModifier(item, type, trait, value, AuraSkillsModifier.Operation.ADD, lore);
    }

    @Override
    public ItemStack addModifier(ItemStack item, ModifierType type, Stat stat, double value, boolean lore) {
        return this.addStatModifier(item, type, stat, value, lore);
    }

    @Override
    public List<StatModifier> getStatModifiers(ItemStack item, ModifierType type) {
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        return skillsItem.getStatModifiers(type);
    }

    @Override
    public List<TraitModifier> getTraitModifiers(ItemStack item, ModifierType type) {
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        return skillsItem.getTraitModifiers(type);
    }

    @Override
    public List<StatModifier> getModifiers(ItemStack item, ModifierType type) {
        return this.getStatModifiers(item, type);
    }

    @Override
    public ItemStack removeStatModifier(ItemStack item, ModifierType type, Stat stat) {
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        skillsItem.removeModifier(SkillsItem.MetaType.MODIFIER, type, stat);
        return skillsItem.getItem();
    }

    @Override
    public ItemStack removeTraitModifier(ItemStack item, ModifierType type, Trait trait) {
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        skillsItem.removeModifier(SkillsItem.MetaType.TRAIT_MODIFIER, type, trait);
        return skillsItem.getItem();
    }

    @Override
    public ItemStack removeModifier(ItemStack item, ModifierType type, Stat stat) {
        return this.removeStatModifier(item, type, stat);
    }

    @Override
    public ItemStack addMultiplier(ItemStack item, ModifierType type, Skill skill, double value, boolean lore) {
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        skillsItem.addMultiplier(type, skill, value);
        if (lore) {
            skillsItem.addMultiplierLore(type, skill, value, this.plugin.getDefaultLanguage());
        }
        return skillsItem.getItem();
    }

    @Override
    public List<Multiplier> getMultipliers(ItemStack item, ModifierType type) {
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        return skillsItem.getMultipliers(type);
    }

    @Override
    public ItemStack removeMultiplier(ItemStack item, ModifierType type, Skill skill) {
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        skillsItem.removeMultiplier(type, skill);
        return skillsItem.getItem();
    }

    @Override
    public ItemStack addRequirement(ItemStack item, ModifierType type, Skill skill, int level, boolean lore) {
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        skillsItem.addRequirement(type, skill, level);
        if (lore) {
            skillsItem.addRequirementLore(type, skill, level, this.plugin.getDefaultLanguage());
        }
        return skillsItem.getItem();
    }

    @Override
    public Map<Skill, Integer> getRequirements(ItemStack item, ModifierType type) {
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        return skillsItem.getRequirements(type);
    }

    @Override
    public ItemStack removeRequirement(ItemStack item, ModifierType type, Skill skill) {
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        skillsItem.removeRequirement(type, skill);
        return skillsItem.getItem();
    }

    @Override
    public boolean passesFilter(ItemStack item, ItemFilter filter) {
        return this.plugin.getItemRegistry().passesFilter(item, filter);
    }

    @Override
    public ItemStack parseItem(ConfigNode config) {
        return this.itemParser.parseItem(((ApiConfigNode)config).getBacking());
    }

    @Override
    public ItemStack parseItem(ConfigurationNode config) {
        return this.itemParser.parseItem(config);
    }

    @Override
    public List<ItemStack> parseMultipleItems(ConfigNode config) {
        try {
            return this.itemParser.parseMultipleItems(((ApiConfigNode)config).getBacking());
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<ItemStack> parseMultipleItems(ConfigurationNode config) {
        try {
            return this.itemParser.parseMultipleItems(config);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
    }
}

