/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.hooks;

import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.user.BukkitUser;
import dev.aurelium.auraskills.common.hooks.EconomyHook;
import dev.aurelium.auraskills.common.hooks.Hook;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.Nullable;

public class VaultHook
extends EconomyHook {
    @Nullable
    private final Economy economy;

    public VaultHook(AuraSkills plugin, ConfigurationNode config) {
        super(plugin, config);
        RegisteredServiceProvider rsp = plugin.getServer().getServicesManager().getRegistration(Economy.class);
        this.economy = rsp != null ? (Economy)rsp.getProvider() : null;
    }

    @Override
    public void deposit(User user, double amount) {
        Player player = ((BukkitUser)user).getPlayer();
        if (player != null && this.economy != null) {
            this.economy.depositPlayer((OfflinePlayer)player, amount);
        }
    }

    @Override
    public Class<? extends Hook> getTypeClass() {
        return EconomyHook.class;
    }
}

