/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.hooks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.nexomc.nexo.api.NexoBlocks;
import com.nexomc.nexo.api.NexoItems;
import com.nexomc.nexo.api.events.NexoItemsLoadedEvent;
import com.nexomc.nexo.api.events.custom_block.noteblock.NexoNoteBlockBreakEvent;
import com.nexomc.nexo.api.events.custom_block.noteblock.NexoNoteBlockPlaceEvent;
import com.nexomc.nexo.items.ItemBuilder;
import com.nexomc.nexo.utils.drops.Drop;
import com.nexomc.nexo.utils.drops.Loot;
import dev.aurelium.auraskills.api.source.type.BlockXpSource;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.source.BlockLeveler;
import dev.aurelium.auraskills.common.hooks.Hook;
import dev.aurelium.auraskills.common.source.SourceTypes;
import dev.aurelium.auraskills.common.source.type.BlockSource;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NexoHook
extends Hook
implements Listener {
    private final AuraSkills plugin;
    @Nullable
    private BlockLeveler blockLeveler;
    private final List<Runnable> itemsLoadedCallbacks = new ArrayList<Runnable>();

    public NexoHook(AuraSkills plugin, ConfigurationNode config) {
        super(plugin, config);
        this.plugin = plugin;
        this.registerExternalItemProvider();
        this.registerBlockParsingExtension();
        this.itemsLoadedCallbacks.add(() -> plugin.getScheduler().scheduleSync(() -> plugin.getMenuFileManager().loadMenus(), 50L, TimeUnit.MILLISECONDS));
    }

    @Override
    public Class<? extends Hook> getTypeClass() {
        return NexoHook.class;
    }

    public List<Runnable> getItemsLoadedCallbacks() {
        return this.itemsLoadedCallbacks;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onNoteBlockPlace(NexoNoteBlockPlaceEvent event) {
        Block block = event.getBlock();
        this.plugin.getRegionManager().handleBlockPlace(block);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onNoteBlockBreak(NexoNoteBlockBreakEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        if (this.blockLeveler == null) {
            this.blockLeveler = this.plugin.getLevelManager().getLeveler(BlockLeveler.class);
        }
        this.blockLeveler.handleBreak(player, block, (Cancellable)event, trait -> this.getUniqueNexoDrops(player, event.getDrop()));
    }

    @EventHandler
    public void onItemsRegister(NexoItemsLoadedEvent event) {
        this.plugin.getItemRegistry().reloadUnresolvedItems("nexo");
        this.itemsLoadedCallbacks.forEach(Runnable::run);
        this.itemsLoadedCallbacks.clear();
    }

    public void registerExternalItemProvider() {
        this.plugin.getItemRegistry().registerExternalItemProvider("nexo", key -> {
            ItemBuilder builder = NexoItems.itemFromId((String)key);
            return builder != null ? builder.build() : null;
        });
    }

    public void registerBlockParsingExtension() {
        this.plugin.getSourceTypeRegistry().registerParsingExtension(SourceTypes.BLOCK, source -> {
            BlockSource block = (BlockSource)source;
            String[] blocks = block.getBlocks();
            if (blocks == null) {
                return block;
            }
             @Nullable BlockXpSource.BlockXpSourceState[] states = block.getStates();
            ArrayList<BlockSource.BlockSourceState> stateBuilder = new ArrayList<BlockSource.BlockSourceState>();
            String nexoPrefix = "nexo:";
            boolean modified = false;
            for (int i = 0; i < blocks.length; ++i) {
                String nextBlockId;
                BlockData blockData;
                String blockId = blocks[i];
                if (!blockId.startsWith("nexo:") || (blockData = NexoBlocks.blockData((String)(nextBlockId = blockId.substring("nexo:".length())))) == null) continue;
                String blockDataString = blockData.getAsString(true);
                Map<String, Object> blockDataMap = BlockLeveler.parseFromBlockData(blockDataString);
                stateBuilder.add(new BlockSource.BlockSourceState((ImmutableMap<String, Object>)ImmutableMap.copyOf(blockDataMap)));
                blocks[i] = blockData.getMaterial().getKey().getKey().toLowerCase(Locale.ROOT);
                modified = true;
            }
            if (!modified) {
                return source;
            }
            if (!stateBuilder.isEmpty()) {
                states = stateBuilder.toArray(new BlockXpSource.BlockXpSourceState[0]);
            }
            return new BlockSource(this.plugin, block.getValues(), blocks, block.getMaxBlocks(), block.getTriggers(), block.checkReplace(), states, block.getAfterStates(), block.getStateMultiplier(), block.getSupportBlockType(), block.allowBoneMeal());
        });
    }

    private ImmutableSet<@NotNull ItemStack> getUniqueNexoDrops(Player player, Drop drop) {
        if (player == null) {
            return ImmutableSet.of();
        }
        HashSet<ItemStack> unique = new HashSet<ItemStack>();
        for (Loot loot : drop.lootToDrop(player)) {
            ItemStack item = loot.getItemStack();
            if (item == null) continue;
            boolean alreadyAdded = false;
            for (ItemStack existing : unique) {
                if (!existing.isSimilar(item)) continue;
                alreadyAdded = true;
                break;
            }
            if (alreadyAdded) continue;
            unique.add(item);
        }
        return ImmutableSet.copyOf(unique);
    }
}

