/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.commands;

import dev.aurelium.auraskills.acf.BaseCommand;
import dev.aurelium.auraskills.acf.annotation.CommandAlias;
import dev.aurelium.auraskills.acf.annotation.CommandCompletion;
import dev.aurelium.auraskills.acf.annotation.CommandPermission;
import dev.aurelium.auraskills.acf.annotation.Default;
import dev.aurelium.auraskills.acf.annotation.Description;
import dev.aurelium.auraskills.acf.annotation.Flags;
import dev.aurelium.auraskills.acf.annotation.Optional;
import dev.aurelium.auraskills.acf.annotation.Subcommand;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.TraitModifier;
import dev.aurelium.auraskills.api.util.AuraSkillsModifier;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.commands.ModifierCommand;
import dev.aurelium.auraskills.bukkit.stat.StatFormat;
import dev.aurelium.auraskills.common.message.type.CommandMessage;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.text.DurationParser;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Locale;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@CommandAlias(value="%skills_alias")
@Subcommand(value="trait")
public class TraitCommand
extends BaseCommand {
    private final AuraSkills plugin;
    private final StatFormat format;

    public TraitCommand(AuraSkills plugin) {
        this.plugin = plugin;
        this.format = new StatFormat(plugin);
    }

    @Subcommand(value="add")
    @CommandPermission(value="auraskills.command.modifier")
    @CommandCompletion(value="@players @traits @nothing @nothing @modifier_operations true true")
    @Description(value="%desc_trait_add")
    public void onAdd(CommandSender sender, @Flags(value="other") Player player, Trait trait, String name, double value, @Default(value="add") AuraSkillsModifier.Operation operation, @Default(value="false") boolean silent, @Default(value="false") boolean stack) {
        User user = this.plugin.getUser(player);
        Locale locale = user.getLocale();
        TraitModifier modifier = new TraitModifier(name, trait, value, operation);
        if (!user.getTraitModifiers().containsKey(name)) {
            user.addTraitModifier(modifier);
            if (!silent) {
                sender.sendMessage(this.plugin.getPrefix(locale) + this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.MODIFIER_ADD_ADDED, locale), modifier, player, locale));
            }
        } else if (stack) {
            String newModifierName = ModifierCommand.getStackedName(user.getTraitModifiers().keySet(), name);
            TraitModifier newModifier = new TraitModifier(newModifierName, trait, value, operation);
            user.addTraitModifier(newModifier);
            if (!silent) {
                sender.sendMessage(this.plugin.getPrefix(locale) + this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.MODIFIER_ADD_ADDED, locale), newModifier, player, locale));
            }
        } else if (!silent) {
            sender.sendMessage(this.plugin.getPrefix(locale) + this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.TRAIT_ADD_ALREADY_EXISTS, locale), modifier, player, locale));
        }
    }

    @Subcommand(value="addtemp")
    @CommandPermission(value="auraskills.command.modifier")
    @CommandCompletion(value="@players @traits @nothing @nothing @nothing true|false @modifier_operations true|false true|false")
    @Description(value="%desc_trait_addtemp")
    public void addTemp(CommandSender sender, @Flags(value="other") Player player, Trait trait, String name, double value, Duration duration, @Default(value="false") boolean pauseOffline, @Default(value="add") AuraSkillsModifier.Operation operation, @Default(value="false") boolean silent, @Default(value="false") boolean stack) {
        String modifierName;
        User user = this.plugin.getUser(player);
        Locale locale = user.getLocale();
        if (!user.getTraitModifiers().containsKey(name)) {
            modifierName = name;
        } else if (stack) {
            modifierName = ModifierCommand.getStackedName(user.getTraitModifiers().keySet(), name);
        } else {
            if (!silent) {
                sender.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.TRAIT_ADD_ALREADY_EXISTS, locale), "{name}", name, "{player}", player.getName()));
            }
            return;
        }
        TraitModifier modifier = new TraitModifier(modifierName, trait, value, operation);
        long expirationTime = System.currentTimeMillis() + duration.toMillis();
        modifier.makeTemporary(expirationTime, pauseOffline);
        user.getUserStats().addTemporaryTraitModifier(modifier, true, expirationTime);
        if (!silent) {
            sender.sendMessage(this.plugin.getPrefix(locale) + this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.TRAIT_ADDTEMP_ADDED, locale), modifier, player, locale).replace("{duration}", DurationParser.toString(duration)));
        }
    }

    @Subcommand(value="remove")
    @CommandPermission(value="auraskills.command.modifier")
    @CommandCompletion(value="@players @modifiers true")
    @Description(value="%desc_trait_remove")
    public void onRemove(CommandSender sender, @Flags(value="other") Player player, String name, @Default(value="false") boolean silent) {
        User user = this.plugin.getUser(player);
        Locale locale = user.getLocale();
        if (user.removeTraitModifier(name)) {
            if (!silent) {
                sender.sendMessage(this.plugin.getPrefix(locale) + this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.MODIFIER_REMOVE_REMOVED, locale), name, player));
            }
        } else if (!silent) {
            sender.sendMessage(this.plugin.getPrefix(locale) + this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.MODIFIER_REMOVE_NOT_FOUND, locale), name, player));
        }
    }

    @Subcommand(value="list")
    @CommandCompletion(value="@players @traits")
    @CommandPermission(value="auraskills.command.modifier")
    @Description(value="%desc_trait_list")
    public void onList(CommandSender sender, @Flags(value="other") @Optional Player player, @Optional Trait trait) {
        Locale locale = this.plugin.getLocale(sender);
        if (player == null) {
            if (sender instanceof Player) {
                Player target = (Player)sender;
                this.listModifiers(sender, target, trait, locale);
            } else {
                sender.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.MODIFIER_LIST_PLAYERS_ONLY, locale));
            }
        } else {
            this.listModifiers(sender, player, trait, locale);
        }
    }

    private void listModifiers(CommandSender sender, @Optional @Flags(value="other") Player player, @Optional Trait trait, Locale locale) {
        StringBuilder message;
        User user = this.plugin.getUser(player);
        if (trait == null) {
            message = new StringBuilder(this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.TRAIT_LIST_ALL_TRAITS_HEADER, locale), player));
            for (String key : user.getTraitModifiers().keySet()) {
                TraitModifier modifier = user.getTraitModifiers().get(key);
                message.append("\n").append(this.format.applyPlaceholders(this.plugin.getRawMsg(CommandMessage.MODIFIER_LIST_ALL_STATS_ENTRY, locale), modifier, player, locale));
            }
        } else {
            message = new StringBuilder(this.format.applyPlaceholders(this.plugin.getRawMsg(CommandMessage.TRAIT_LIST_ONE_TRAIT_HEADER, locale), trait, player, locale));
            for (String key : user.getTraitModifiers().keySet()) {
                TraitModifier modifier = user.getTraitModifiers().get(key);
                if (!modifier.trait().equals(trait)) continue;
                message.append("\n").append(this.format.applyPlaceholders(this.plugin.getRawMsg(CommandMessage.MODIFIER_LIST_ONE_STAT_ENTRY, locale), modifier, player, locale));
            }
        }
        sender.sendMessage(message.toString());
    }

    @Subcommand(value="removeall")
    @CommandCompletion(value="@players @traits")
    @CommandPermission(value="auraskills.command.modifier")
    @Description(value="%desc_trait_removeall")
    public void onRemoveAll(CommandSender sender, @Flags(value="other") @Optional Player player, @Optional Trait trait, @Default(value="false") boolean silent) {
        Locale locale = this.plugin.getLocale(sender);
        if (player == null) {
            if (sender instanceof Player) {
                Player target = (Player)sender;
                this.removeAllModifiers(sender, trait, silent, locale, target, this.plugin.getUser(target));
            } else if (!silent) {
                sender.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.MODIFIER_REMOVEALL_PLAYERS_ONLY, locale));
            }
        } else {
            this.removeAllModifiers(sender, trait, silent, locale, player, this.plugin.getUser(player));
        }
    }

    private void removeAllModifiers(CommandSender sender, @Optional Trait trait, @Default(value="false") boolean silent, Locale locale, Player target, User user) {
        int removed = 0;
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String key : user.getTraitModifiers().keySet()) {
            if (trait == null) {
                toRemove.add(key);
                ++removed;
                continue;
            }
            if (!user.getTraitModifiers().get(key).trait().equals(trait)) continue;
            toRemove.add(key);
            ++removed;
        }
        for (String key : toRemove) {
            user.removeTraitModifier(key);
        }
        if (!silent) {
            if (trait == null) {
                sender.sendMessage(this.plugin.getPrefix(locale) + this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.TRAIT_REMOVEALL_REMOVED_ALL_TRAITS, locale), target).replace("{num}", String.valueOf(removed)));
            } else {
                sender.sendMessage(this.plugin.getPrefix(locale) + this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.MODIFIER_REMOVEALL_REMOVED_ONE_STAT, locale), trait, target, locale).replace("{num}", String.valueOf(removed)));
            }
        }
    }
}

