/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.commands;

import dev.aurelium.auraskills.acf.BaseCommand;
import dev.aurelium.auraskills.acf.annotation.CommandAlias;
import dev.aurelium.auraskills.acf.annotation.CommandPermission;
import dev.aurelium.auraskills.acf.annotation.Subcommand;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.common.storage.StorageProvider;
import dev.aurelium.auraskills.common.user.UserState;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;

@CommandAlias(value="%skills_alias")
@Subcommand(value="storage")
public class StorageCommand
extends BaseCommand {
    private final AuraSkills plugin;

    public StorageCommand(AuraSkills plugin) {
        this.plugin = plugin;
    }

    @Subcommand(value="mergeskills")
    @CommandPermission(value="auraskills.command.storage")
    public void onMergeSkills(CommandSender sender, String from, String to) {
        if (!(sender instanceof ConsoleCommandSender) && !(sender instanceof RemoteConsoleCommandSender)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only console can execute this command!");
            return;
        }
        int failed = 0;
        int success = 0;
        try {
            StorageProvider storage = this.plugin.getStorageProvider();
            for (UserState state : storage.loadStates(false, false)) {
                Map.Entry fromEntry = state.skillLevels().entrySet().stream().filter(e -> ((Skill)e.getKey()).getId().toString().equals(from)).findFirst().orElse(null);
                Map.Entry toEntry = state.skillLevels().entrySet().stream().filter(e -> ((Skill)e.getKey()).getId().toString().equals(to)).findFirst().orElse(null);
                if (fromEntry == null || toEntry == null) {
                    ++failed;
                    continue;
                }
                if ((Integer)fromEntry.getValue() > (Integer)toEntry.getValue()) {
                    state.skillLevels().put((Skill)toEntry.getKey(), (Integer)fromEntry.getValue());
                    state.skillXp().put((Skill)toEntry.getKey(), state.skillXp().getOrDefault(fromEntry.getKey(), 0.0));
                    try {
                        storage.applyState(state);
                    }
                    catch (Exception e2) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to apply user state of user " + state.uuid().toString());
                        ++failed;
                        continue;
                    }
                }
                ++success;
            }
        }
        catch (Exception e3) {
            throw new RuntimeException(e3);
        }
        sender.sendMessage("Merged skill " + from + " into " + to + ", applying the higher skill level. Successfully applied to " + success + " users, failed to apply for " + failed + " users.");
    }

    @Subcommand(value="removeallmodifiers")
    @CommandPermission(value="auraskills.command.storage")
    public void removeAllModifiers(CommandSender sender) {
        if (!(sender instanceof ConsoleCommandSender) && !(sender instanceof RemoteConsoleCommandSender)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only console can execute this command!");
            return;
        }
        int failed = 0;
        int success = 0;
        int skipped = 0;
        try {
            StorageProvider storage = this.plugin.getStorageProvider();
            for (UserState state : storage.loadStates(false, false)) {
                if (state.statModifiers().isEmpty() && state.traitModifiers().isEmpty()) {
                    ++skipped;
                    continue;
                }
                UserState newState = new UserState(state.uuid(), state.skillLevels(), state.skillXp(), Map.of(), Map.of(), state.mana());
                try {
                    storage.applyState(newState);
                    ++success;
                }
                catch (Exception e) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to apply user state of user " + state.uuid().toString());
                    ++failed;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        sender.sendMessage("Removed all stat and trait modifiers for all users. Successfully applied to " + success + " users, failed to apply for " + failed + " users, " + skipped + " users had no modifiers to remove.");
    }
}

