/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.commands;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.aurelium.auraskills.acf.BaseCommand;
import dev.aurelium.auraskills.acf.annotation.CommandAlias;
import dev.aurelium.auraskills.acf.annotation.CommandCompletion;
import dev.aurelium.auraskills.acf.annotation.CommandPermission;
import dev.aurelium.auraskills.acf.annotation.Default;
import dev.aurelium.auraskills.acf.annotation.Description;
import dev.aurelium.auraskills.acf.annotation.Flags;
import dev.aurelium.auraskills.acf.annotation.Optional;
import dev.aurelium.auraskills.acf.annotation.Subcommand;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.skill.Skills;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.commands.JsonArg;
import dev.aurelium.auraskills.common.message.type.ACFCoreMessage;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import dev.aurelium.auraskills.slate.builder.BuiltMenu;
import dev.aurelium.auraskills.slate.info.MenuInfo;
import dev.aurelium.auraskills.slate.menu.ActiveMenu;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

@CommandAlias(value="%skills_alias")
@Subcommand(value="openmenu")
public class OpenMenuCommand
extends BaseCommand {
    private final AuraSkills plugin;
    private final Type mapType;
    private final Gson gson;

    public OpenMenuCommand(AuraSkills plugin) {
        this.plugin = plugin;
        this.mapType = new TypeToken<Map<String, Object>>(){}.getType();
        this.gson = new GsonBuilder().registerTypeAdapter(this.mapType, this.getDeserializer()).create();
    }

    @Default
    @CommandPermission(value="auraskills.command.openmenu")
    @CommandCompletion(value="@menu_names @players")
    @Description(value="%desc_openmenu")
    public void onOpenMenu(CommandSender sender, String menuName, @Optional @Flags(value="other") Player target, @Optional JsonArg properties, @Default(value="0") int page) {
        Locale locale = this.plugin.getLocale(sender);
        if (target == null) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.openMenuLogError((CommandSender)player, menuName, player, properties, page);
            } else {
                sender.sendMessage(this.plugin.getMsg(ACFCoreMessage.NOT_ALLOWED_ON_CONSOLE, locale));
            }
        } else {
            this.openMenuLogError(sender, menuName, target, properties, page);
        }
    }

    private void openMenuLogError(CommandSender sender, String menuName, Player target, @Nullable JsonArg properties, int page) {
        Locale locale = this.plugin.getLocale(sender);
        try {
            this.plugin.getSlate().openMenuUnchecked(target, menuName, this.getProperties(target, menuName, properties), page);
        }
        catch (Exception e) {
            target.closeInventory();
            String errorMsg = TextUtil.replace(this.plugin.getMsg(ACFCoreMessage.ERROR_PREFIX, locale), "{message}", e.getMessage() != null ? e.getMessage() : "Check console for error");
            sender.sendMessage(errorMsg);
            e.printStackTrace();
        }
    }

    private Map<String, Object> getProperties(Player player, String menuName, @Nullable JsonArg propString) {
        String jsonString;
        BuiltMenu builtMenu = this.plugin.getSlate().getBuiltMenu(menuName);
        MenuInfo menuInfo = new MenuInfo(this.plugin.getSlate(), player, ActiveMenu.empty(this.plugin.getSlate(), player));
        ConcurrentHashMap<String, Object> properties = new ConcurrentHashMap<String, Object>(builtMenu.propertyProvider().get(menuInfo));
        if (propString != null && (jsonString = propString.json()).startsWith("{") && jsonString.endsWith("}")) {
            Map parsedProps = (Map)this.gson.fromJson(propString.json(), this.mapType);
            properties.putAll(parsedProps);
        }
        return properties;
    }

    private JsonDeserializer<Map<String, Object>> getDeserializer() {
        return (json, typeOfT, context) -> {
            ConcurrentHashMap<String, Object> resultMap = new ConcurrentHashMap<String, Object>();
            JsonObject jsonObject = json.getAsJsonObject();
            Set entrySet = jsonObject.entrySet();
            for (Map.Entry entry : entrySet) {
                String key = (String)entry.getKey();
                JsonElement value = (JsonElement)entry.getValue();
                if (value.isJsonPrimitive() && value.getAsString().startsWith("Skill:")) {
                    String skillName = value.getAsString().substring(6);
                    Skill skill = (Skill)this.plugin.getSkillRegistry().getOrNull(NamespacedId.fromDefault(skillName));
                    resultMap.put(key, skill != null ? skill : Skills.FARMING);
                    continue;
                }
                resultMap.put(key, context.deserialize(value, Object.class));
            }
            return resultMap;
        };
    }
}

