/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.commands;

import dev.aurelium.auraskills.acf.BaseCommand;
import dev.aurelium.auraskills.acf.annotation.CommandAlias;
import dev.aurelium.auraskills.acf.annotation.CommandCompletion;
import dev.aurelium.auraskills.acf.annotation.CommandPermission;
import dev.aurelium.auraskills.acf.annotation.Default;
import dev.aurelium.auraskills.acf.annotation.Description;
import dev.aurelium.auraskills.acf.annotation.Flags;
import dev.aurelium.auraskills.acf.annotation.Subcommand;
import dev.aurelium.auraskills.api.event.mana.ManaAbilityRefreshEvent;
import dev.aurelium.auraskills.api.mana.ManaAbility;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.common.mana.ManaAbilityData;
import dev.aurelium.auraskills.common.message.MessageBuilder;
import dev.aurelium.auraskills.common.message.MessageKey;
import dev.aurelium.auraskills.common.message.type.CommandMessage;
import dev.aurelium.auraskills.common.user.User;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@CommandAlias(value="%skills_alias")
@Subcommand(value="manaability")
public class ManaAbilityCommand
extends BaseCommand {
    private final AuraSkills plugin;

    public ManaAbilityCommand(AuraSkills plugin) {
        this.plugin = plugin;
    }

    @Subcommand(value="resetcooldown")
    @CommandCompletion(value="@players @mana_abilities false|true")
    @CommandPermission(value="auraskills.command.manaability.resetcooldown")
    @Description(value="%desc_manaability_resetcooldown")
    public void onResetCooldown(CommandSender sender, @Flags(value="other") Player player, ManaAbility ability, @Default(value="false") boolean fillMana) {
        User user = this.plugin.getUser(player);
        Locale locale = user.getLocale();
        if (ability.isEnabled()) {
            ManaAbilityData data = user.getManaAbilityData(ability);
            if (data.getCooldown() > 0 && !data.isActivated()) {
                data.setCooldown(0);
                ManaAbilityRefreshEvent event = new ManaAbilityRefreshEvent(player, user.toApi(), ability);
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            if (fillMana) {
                user.setMana(user.getMaxMana());
            }
            sender.sendMessage(MessageBuilder.create(this.plugin).locale(locale).prefix().message((MessageKey)CommandMessage.MANAABILITY_RESETCOOLDOWN_COOLDOWN_RESET, "player", player.getName(), "ability", ability.getDisplayName(locale)).toString());
        } else {
            sender.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.UNKNOWN_MANA_ABILITY, locale));
        }
    }
}

