/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.commands;

import dev.aurelium.auraskills.acf.CommandIssuer;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class ConfirmManager {
    private final AuraSkills plugin;
    private final Map<UUID, String> confirmMap = new ConcurrentHashMap<UUID, String>();

    public ConfirmManager(AuraSkills plugin) {
        this.plugin = plugin;
    }

    public boolean requiresConfirmation(CommandIssuer issuer, String arg) {
        return this.requiresConfirmation(issuer, arg, false);
    }

    public boolean requiresConfirmation(CommandIssuer issuer, String arg, boolean requireConsole) {
        if (!issuer.isPlayer() && !requireConsole) {
            return false;
        }
        UUID uuid = issuer.getUniqueId();
        String existing = this.confirmMap.get(uuid);
        if (existing != null && existing.equals(arg)) {
            return false;
        }
        this.confirmMap.put(uuid, arg);
        this.plugin.getScheduler().scheduleSync(() -> {
            if (arg.equals(this.confirmMap.getOrDefault(uuid, ""))) {
                this.confirmMap.remove(uuid);
            }
        }, 30L, TimeUnit.SECONDS);
        return true;
    }

    public void remove(CommandIssuer issuer) {
        this.confirmMap.remove(issuer.getUniqueId());
    }
}

