/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.api.trait;

import dev.aurelium.auraskills.api.annotation.Inject;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.TraitProvider;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public enum Traits implements Trait
{
    ATTACK_DAMAGE,
    HP,
    SATURATION_REGEN,
    HUNGER_REGEN,
    MANA_REGEN,
    LUCK,
    FARMING_LUCK,
    FORAGING_LUCK,
    MINING_LUCK,
    FISHING_LUCK,
    EXCAVATION_LUCK,
    DOUBLE_DROP,
    EXPERIENCE_BONUS,
    ANVIL_DISCOUNT,
    MAX_MANA,
    DAMAGE_REDUCTION,
    CRIT_CHANCE,
    CRIT_DAMAGE,
    MOVEMENT_SPEED;

    @Inject
    private TraitProvider provider;
    private final NamespacedId id = NamespacedId.of("auraskills", this.name().toLowerCase(Locale.ROOT));

    @Override
    public NamespacedId getId() {
        return this.id;
    }

    @Override
    public boolean isEnabled() {
        return this.provider.isEnabled(this);
    }

    @Override
    public String getDisplayName(Locale locale) {
        this.validate();
        return this.provider.getDisplayName(this, locale, true);
    }

    @Override
    public String getDisplayName(Locale locale, boolean formatted) {
        this.validate();
        return this.provider.getDisplayName(this, locale, formatted);
    }

    @Override
    public String getMenuDisplay(double value, Locale locale) {
        this.validate();
        return this.provider.getMenuDisplay(this, value, locale);
    }

    private void validate() {
        if (this.provider == null) {
            throw new IllegalStateException("Attempting to access stat provider before it has been injected!");
        }
    }

    @Override
    public boolean optionBoolean(String key) {
        return this.provider.optionBoolean(this, key);
    }

    @Override
    public boolean optionBoolean(String key, boolean def) {
        return this.provider.optionBoolean(this, key, def);
    }

    @Override
    public int optionInt(String key) {
        return this.provider.optionInt(this, key);
    }

    @Override
    public int optionInt(String key, int def) {
        return this.provider.optionInt(this, key, def);
    }

    @Override
    public double optionDouble(String key) {
        return this.provider.optionDouble(this, key);
    }

    @Override
    public double optionDouble(String key, double def) {
        return this.provider.optionDouble(this, key, def);
    }

    @Override
    public String optionString(String key) {
        return this.provider.optionString(this, key);
    }

    @Override
    public String optionString(String key, String def) {
        return this.provider.optionString(this, key, def);
    }

    @Override
    public List<String> optionStringList(String key) {
        return this.provider.optionStringList(this, key);
    }

    @Override
    public Map<String, Object> optionMap(String key) {
        return this.provider.optionMap(this, key);
    }

    public String toString() {
        return this.id.toString();
    }
}

