/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.api.source;

import dev.aurelium.auraskills.api.AuraSkillsApi;
import dev.aurelium.auraskills.api.AuraSkillsBukkit;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.source.SourceType;
import dev.aurelium.auraskills.api.user.SkillsUser;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.jetbrains.annotations.Nullable;

public class LevelerContext {
    private final AuraSkillsApi api;
    @Nullable
    private final SourceType sourceType;

    public LevelerContext(AuraSkillsApi api) {
        this(api, null);
    }

    public LevelerContext(AuraSkillsApi api, @Nullable SourceType sourceType) {
        this.api = api;
        this.sourceType = sourceType;
    }

    public boolean disabled() {
        if (this.sourceType != null) {
            return !this.sourceType.isEnabled();
        }
        return false;
    }

    public boolean failsChecks(Cancellable event, Player player, Location location, Skill skill) {
        return this.isDisabled(skill) || this.isCancelled(event, skill) || this.blockLocation(player, location, skill) || this.blockPlayer(player, skill);
    }

    public boolean failsChecks(Player player, Location location, Skill skill) {
        return this.isDisabled(skill) || this.blockLocation(player, location, skill) || this.blockPlayer(player, skill);
    }

    public boolean isDisabled(Skill skill) {
        return !skill.isEnabled();
    }

    public boolean isCancelled(Cancellable event, Skill skill) {
        return skill.optionBoolean("check_cancelled", true) && event.isCancelled();
    }

    public boolean blockLocation(Player player, Location location, Skill skill) {
        return AuraSkillsBukkit.get().getLocationManager().isXpGainBlocked(location, player, skill);
    }

    public boolean blockPlayer(Player player, Skill skill) {
        SkillsUser skillsUser = AuraSkillsApi.get().getUser(player.getUniqueId());
        if (!skillsUser.hasSkillPermission(skill)) {
            return true;
        }
        return this.api.getMainConfig().isDisabledInCreative() && player.getGameMode().equals((Object)GameMode.CREATIVE);
    }
}

