/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.api.loot;

import dev.aurelium.auraskills.api.loot.LootPool;
import dev.aurelium.auraskills.api.loot.LootRequirements;
import dev.aurelium.auraskills.api.loot.LootTableType;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class LootTable {
    private final NamespacedId id;
    private final UUID uuid;
    private final LootTableType type;
    private final List<LootPool> pools;
    private final LootRequirements requirements;

    public LootTable(NamespacedId id, UUID uuid, LootTableType type, List<LootPool> pools, LootRequirements requirements) {
        this.id = id;
        this.uuid = uuid;
        this.type = type;
        this.pools = pools;
        this.requirements = requirements;
    }

    public NamespacedId getId() {
        return this.id;
    }

    public UUID uuid() {
        return this.uuid;
    }

    public LootTableType getType() {
        return this.type;
    }

    @Nullable
    public LootPool getPool(String name) {
        for (LootPool pool : this.pools) {
            if (!pool.getName().equals(name)) continue;
            return pool;
        }
        return null;
    }

    public List<LootPool> getPools() {
        return this.pools;
    }

    public boolean checkRequirements(UUID uuid) {
        return this.requirements.checkByUuid(uuid);
    }
}

