/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.updates;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.updates.BaseJenkins;
import me.libraryaddict.disguise.utilities.updates.DisguiseUpdate;
import me.libraryaddict.disguise.utilities.updates.UpdateChecker;

public class LDJenkins
extends BaseJenkins {
    private UpdateChecker updateChecker;

    public LDJenkins() {
        super("https://ci.lib.co.nz/job/LibsDisguises/");
    }

    private String[] getBadUsers() {
        try {
            HashMap map;
            URL url = new URL("https://api.github.com/repos/libraryaddict/libsdisguises/issues/469");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestProperty("User-Agent", "libraryaddict/LibsDisguises");
            con.setRequestProperty("Accept", "application/vnd.github.v3+json");
            try (InputStream input = con.getInputStream();){
                String json = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                map = (HashMap)new Gson().fromJson(json, HashMap.class);
            }
            con.disconnect();
            if (!map.containsKey("body")) {
                return new String[0];
            }
            return ((String)map.get("body")).split("[\\r\\n]+");
        }
        catch (Exception exception) {
            return new String[0];
        }
    }

    @Override
    protected Map<String, Object> fetchLastSnapshotBuild() {
        try {
            String[] users;
            for (String s : users = this.getBadUsers()) {
                if (LibsPremium.getPaidInformation() == null || !s.equals(LibsPremium.getPaidInformation().getDownloadID()) && !s.equals(LibsPremium.getPaidInformation().getUserID())) continue;
                LibsDisguises.getInstance().unregisterCommands(true);
            }
            LibsDisguises.getInstance().getLogger().info("Now looking for update on Jenkins..");
            return super.fetchLastSnapshotBuild();
        }
        catch (Exception ex) {
            LibsDisguises.getInstance().getLogger().warning("Failed to check for a snapshot update on jenkins.");
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public DisguiseUpdate getLatestSnapshot() {
        BaseJenkins.JenkinsUpdate update = (BaseJenkins.JenkinsUpdate)super.getLatestSnapshot();
        return new LDJenkinsUpdate(update.getDownload(), update.getChangelog(), update.getDownloads());
    }

    static class LDJenkinsUpdate
    extends BaseJenkins.JenkinsUpdate {
        public LDJenkinsUpdate(String version, String[] changelog, List<String> downloads) {
            super(version, changelog, downloads);
        }

        @Override
        public String getDownload() {
            return "https://ci.lib.co.nz/job/LibsDisguises/lastSuccessfulBuild/artifact/target/LibsDisguises.jar?v=" + System.currentTimeMillis();
        }
    }
}

