/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.sounds;

import com.github.retrooper.packetevents.protocol.entity.data.struct.WeatheringCopperState;
import com.github.retrooper.packetevents.protocol.entity.wolfvariant.WolfSoundVariant;
import com.github.retrooper.packetevents.protocol.entity.wolfvariant.WolfSoundVariants;
import com.github.retrooper.packetevents.protocol.mapper.MappedEntity;
import com.github.retrooper.packetevents.resources.ResourceLocation;
import com.github.retrooper.packetevents.util.mappings.VersionedRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.CopperGolemWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.WolfWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.sounds.DisguiseSoundCategory;
import org.apache.commons.lang.math.RandomUtils;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HappyGhast;
import org.bukkit.entity.Wolf;

public class SoundGroup {
    private static final LinkedHashMap<String, SoundGroup> groups = new LinkedHashMap();
    private float damageAndIdleSoundVolume = 1.0f;
    private final LinkedHashMap<ResourceLocation, SoundType> disguiseSoundTypes = new LinkedHashMap();
    private final LinkedHashMap<SoundType, ResourceLocation[]> disguiseSounds = new LinkedHashMap();
    private boolean customSounds;
    private final DisguiseSoundCategory soundCategory;

    public SoundGroup(String name) {
        this(name, null);
    }

    public SoundGroup(String name, DisguiseSoundCategory category) {
        groups.put(name, this);
        this.soundCategory = category;
        try {
            DisguiseType.valueOf(name);
        }
        catch (Exception ex) {
            this.customSounds = true;
        }
    }

    public DisguiseSoundCategory getCategory() {
        if (this.soundCategory == null) {
            return DisguiseConfig.getSoundCategory();
        }
        return this.soundCategory;
    }

    public void addSound(ResourceLocation soundString, SoundType type) {
        if (soundString == null) {
            return;
        }
        this.disguiseSoundTypes.putIfAbsent(soundString, type);
        if (this.disguiseSounds.containsKey((Object)type)) {
            ResourceLocation[] array = this.disguiseSounds.get((Object)type);
            array = Arrays.copyOf(array, array.length + 1);
            array[array.length - 1] = soundString;
            this.disguiseSounds.put(type, array);
        } else {
            this.disguiseSounds.put(type, new ResourceLocation[]{soundString});
        }
    }

    public ResourceLocation getSound(SoundType type) {
        if (type == null) {
            return null;
        }
        if (this.customSounds) {
            return this.getRandomSound(type);
        }
        ResourceLocation[] sounds = this.disguiseSounds.get((Object)type);
        if (sounds == null) {
            return null;
        }
        return sounds[0];
    }

    private ResourceLocation getRandomSound(SoundType type) {
        if (type == null) {
            return null;
        }
        ResourceLocation[] sounds = this.disguiseSounds.get((Object)type);
        if (sounds == null) {
            return null;
        }
        return sounds[RandomUtils.nextInt((int)sounds.length)];
    }

    public SoundType getSound(ResourceLocation sound) {
        if (sound == null) {
            return null;
        }
        return this.disguiseSoundTypes.get(sound);
    }

    public SoundType getType(ResourceLocation sound) {
        if (sound == null) {
            return SoundType.CANCEL;
        }
        return this.getSound(sound);
    }

    public static SoundGroup getGroup(Disguise disguise) {
        WolfSoundVariant variant;
        SoundGroup dSoundGroup;
        if (disguise.getSoundGroup() != null && (dSoundGroup = SoundGroup.getGroup(disguise.getSoundGroup())) != null) {
            return dSoundGroup;
        }
        String variantName = null;
        if (NmsVersion.v1_21_R4.isSupported() && disguise.getWatcher() instanceof WolfWatcher) {
            variant = ((WolfWatcher)disguise.getWatcher()).getSoundVariant();
            variantName = variant.getName().getKey();
        } else if (NmsVersion.v1_21_R6.isSupported() && disguise.getWatcher() instanceof CopperGolemWatcher && ((variant = ((CopperGolemWatcher)disguise.getWatcher()).getOxidation()) == WeatheringCopperState.WEATHERED || variant == WeatheringCopperState.OXIDIZED)) {
            variantName = variant.name().toLowerCase(Locale.ENGLISH);
        }
        String entityName = disguise.getType().name();
        if (disguise.getType() == DisguiseType.HAPPY_GHAST && disguise.getWatcher() instanceof AgeableWatcher && ((AgeableWatcher)disguise.getWatcher()).isBaby()) {
            entityName = "GHASTLING";
        }
        return SoundGroup.getGroup(entityName, variantName);
    }

    public static SoundGroup getGroup(Entity entity) {
        String name = entity.getType().name();
        String variantName = null;
        if (entity instanceof Wolf && NmsVersion.v1_21_R4.isSupported()) {
            variantName = DisguiseUtilities.isRunningPaper() ? ((Wolf)entity).getSoundVariant().getKey().getKey() : ReflectionManager.getNmsReflection().getVariant(entity, (VersionedRegistry<? extends MappedEntity>)WolfSoundVariants.getRegistry());
        } else if (NmsVersion.v1_21_R5.isSupported() && entity instanceof HappyGhast && !((Ageable)entity).isAdult()) {
            name = "GHASTLING";
        }
        return SoundGroup.getGroup(name, variantName);
    }

    public static SoundGroup[] getGroups(String name) {
        ArrayList<SoundGroup> list = new ArrayList<SoundGroup>();
        for (Map.Entry<String, SoundGroup> entry : groups.entrySet()) {
            if (!entry.getKey().split("\\$")[0].equals(name)) continue;
            list.add(entry.getValue());
        }
        return list.toArray(new SoundGroup[0]);
    }

    public static SoundGroup getGroup(String name) {
        return SoundGroup.getGroup(name, null);
    }

    public static SoundGroup getGroup(String name, String variant) {
        if (variant != null) {
            return groups.getOrDefault(name + "$" + variant, groups.get(name));
        }
        return groups.get(name);
    }

    @Generated
    public static LinkedHashMap<String, SoundGroup> getGroups() {
        return groups;
    }

    @Generated
    public float getDamageAndIdleSoundVolume() {
        return this.damageAndIdleSoundVolume;
    }

    @Generated
    public void setDamageAndIdleSoundVolume(float damageAndIdleSoundVolume) {
        this.damageAndIdleSoundVolume = damageAndIdleSoundVolume;
    }

    @Generated
    public LinkedHashMap<ResourceLocation, SoundType> getDisguiseSoundTypes() {
        return this.disguiseSoundTypes;
    }

    @Generated
    public LinkedHashMap<SoundType, ResourceLocation[]> getDisguiseSounds() {
        return this.disguiseSounds;
    }

    public static enum SoundType {
        CANCEL,
        DEATH,
        HURT,
        IDLE,
        STEP;

    }
}

