/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.sounds;

import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.bukkit.SoundCategory;

public enum DisguiseSoundCategory {
    AMBIENT(com.github.retrooper.packetevents.protocol.sound.SoundCategory.AMBIENT),
    BLOCKS(com.github.retrooper.packetevents.protocol.sound.SoundCategory.BLOCK),
    HOSTILE(com.github.retrooper.packetevents.protocol.sound.SoundCategory.HOSTILE),
    MASTER(com.github.retrooper.packetevents.protocol.sound.SoundCategory.MASTER),
    MUSIC(com.github.retrooper.packetevents.protocol.sound.SoundCategory.MUSIC),
    NEUTRAL(com.github.retrooper.packetevents.protocol.sound.SoundCategory.NEUTRAL),
    PLAYERS(com.github.retrooper.packetevents.protocol.sound.SoundCategory.PLAYER),
    RECORDS(com.github.retrooper.packetevents.protocol.sound.SoundCategory.RECORD),
    UI(com.github.retrooper.packetevents.protocol.sound.SoundCategory.UI),
    VOICE(com.github.retrooper.packetevents.protocol.sound.SoundCategory.VOICE),
    WEATHER(com.github.retrooper.packetevents.protocol.sound.SoundCategory.WEATHER),
    ACTUAL(null),
    DISGUISE(null);

    private final com.github.retrooper.packetevents.protocol.sound.SoundCategory soundCategory;
    private final SoundCategory bSoundCategory;

    private DisguiseSoundCategory(com.github.retrooper.packetevents.protocol.sound.SoundCategory soundCategory) {
        this.soundCategory = soundCategory;
        SoundCategory category = SoundCategory.MASTER;
        if (!this.name().equals("ACTUAL") && !this.name().equals("DISGUISE")) {
            try {
                category = SoundCategory.valueOf((String)this.name());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.bSoundCategory = category;
    }

    public SoundCategory getBukkitSoundCategory(Disguise disguise) {
        if (this == ACTUAL && disguise.getEntity() != null) {
            return ReflectionManager.getBukkitSoundCategory(DisguiseType.getType(disguise.getEntity()));
        }
        if (this == DISGUISE) {
            return ReflectionManager.getBukkitSoundCategory(disguise.getType());
        }
        return this.bSoundCategory;
    }

    public com.github.retrooper.packetevents.protocol.sound.SoundCategory getSoundCategory(Disguise disguise) {
        if (this == ACTUAL && disguise.getEntity() != null) {
            return ReflectionManager.getSoundCategory(DisguiseType.getType(disguise.getEntity()));
        }
        if (this == DISGUISE) {
            return ReflectionManager.getSoundCategory(disguise.getType());
        }
        return this.soundCategory;
    }

    public boolean isAvailable() {
        return this != UI || NmsVersion.v1_21_R6.isSupported();
    }

    public static DisguiseSoundCategory byName(String name) {
        DisguiseSoundCategory category = DisguiseSoundCategory.valueOf(name);
        if (category != null && !category.isAvailable()) {
            throw new IllegalArgumentException("Cannot use " + category.name() + " on this version of MC!");
        }
        return category;
    }
}

