/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.scaling;

import lombok.Generated;
import me.libraryaddict.disguise.DisguiseConfig;

public class DisguiseScaling {
    private static final double playerHeight = 1.8;
    private static final double maxTinyFigureHeight = 1.15;
    private static final double tallDisguiseAtHeight = 1.6;
    private final DisguiseScalingInternals scalingInternals;

    public double getHeightOfDisguise() {
        return this.getScalingInternals().getUnscaledHeight() * this.getScalingInternals().getDisguiseScale();
    }

    public void adjustScaling() {
        double playerScaleWithoutLibsDisguises = this.getScalingInternals().getPlayerScaleWithoutLibsDisguises();
        double unscaledHeightOfDisguise = this.getScalingInternals().getUnscaledHeight();
        double increasedNaturalHeightOfDisguise = this.getHeightOfDisguise();
        double scalerToMakePlayerSeePerspective = 1.0;
        if (this.getScalingInternals().isScalePlayerToDisguise()) {
            scalerToMakePlayerSeePerspective = DisguiseScaling.getScaleToMakePlayerSeePerspective(increasedNaturalHeightOfDisguise, playerScaleWithoutLibsDisguises);
        }
        double prevTinyFigureScaleMax = this.getScalingInternals().getPrevSelfDisguiseTallScaleMax();
        double newTinyFigureScaleMax = DisguiseScaling.getMaxTinyFigureHeight(DisguiseScaling.getPlayerHeight() * playerScaleWithoutLibsDisguises * scalerToMakePlayerSeePerspective, unscaledHeightOfDisguise);
        newTinyFigureScaleMax = Math.min(newTinyFigureScaleMax, Math.max(this.getScalingInternals().getDisguiseScale(), playerScaleWithoutLibsDisguises));
        this.getScalingInternals().setSelfDisguiseTallScaleMax(newTinyFigureScaleMax);
        if (!this.getScalingInternals().isScalingRelevant()) {
            return;
        }
        if (prevTinyFigureScaleMax != newTinyFigureScaleMax) {
            if (this.getScalingInternals().isTinyFigureScaleable()) {
                this.getScalingInternals().sendTinyFigureScale(newTinyFigureScaleMax);
            } else {
                this.getScalingInternals().sendTinyFigureScale(playerScaleWithoutLibsDisguises);
            }
        }
        this.getScalingInternals().setPlayerScale(scalerToMakePlayerSeePerspective);
    }

    private static double getMaxTinyFigureHeight(double finalPlayerHeight, double naturalDisguiseHeight) {
        return DisguiseScaling.getMaxTinyFigureHeight() / DisguiseScaling.getPlayerHeight() * finalPlayerHeight / naturalDisguiseHeight;
    }

    private static double getScaleToMakePlayerSeePerspective(double heightOfDisguise, double playerScaleWithoutLibsDisguises) {
        double scalerToMakePlayerSeePerspective = heightOfDisguise / (DisguiseScaling.getPlayerHeight() * playerScaleWithoutLibsDisguises);
        scalerToMakePlayerSeePerspective = Math.min(scalerToMakePlayerSeePerspective, DisguiseConfig.getScaleSelfDisguisesMax());
        scalerToMakePlayerSeePerspective = Math.max(scalerToMakePlayerSeePerspective, DisguiseConfig.getScaleSelfDisguisesMin());
        return scalerToMakePlayerSeePerspective;
    }

    @Generated
    public DisguiseScalingInternals getScalingInternals() {
        return this.scalingInternals;
    }

    @Generated
    public DisguiseScaling(DisguiseScalingInternals scalingInternals) {
        this.scalingInternals = scalingInternals;
    }

    @Generated
    public static double getPlayerHeight() {
        return 1.8;
    }

    @Generated
    public static double getMaxTinyFigureHeight() {
        return 1.15;
    }

    @Generated
    public static double getTallDisguiseAtHeight() {
        return 1.6;
    }

    public static interface DisguiseScalingInternals {
        public void sendTinyFigureScale(double var1);

        public void setPlayerScale(double var1);

        public boolean isScalingRelevant();

        public boolean isTinyFigureScaleable();

        public boolean isScalePlayerToDisguise();

        public boolean isTallDisguise();

        public double getUnscaledHeight();

        public double getDisguiseScale();

        public double getPlayerScaleWithoutLibsDisguises();

        public double getPrevSelfDisguiseTallScaleMax();

        public void setSelfDisguiseTallScaleMax(double var1);
    }
}

